/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.rfile;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.LoadPlan;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;

class LoadPlanCollector {
    private final LoadPlan.SplitResolver splitResolver;
    private boolean finished = false;
    private Text lgFirstRow;
    private Text lgLastRow;
    private Text firstRow;
    private Text lastRow;
    private Set<KeyExtent> overlappingExtents;
    private KeyExtent currentExtent;
    private long appended = 0L;
    private static final TableId FAKE_ID = TableId.of("123");

    LoadPlanCollector(LoadPlan.SplitResolver splitResolver) {
        this.splitResolver = splitResolver;
        this.overlappingExtents = new HashSet<KeyExtent>();
    }

    LoadPlanCollector() {
        this.splitResolver = null;
        this.overlappingExtents = null;
    }

    private void appendNoSplits(Key key) {
        Text row;
        this.lgLastRow = this.lgFirstRow == null ? (this.lgFirstRow = key.getRow()) : (row = key.getRow());
    }

    private void appendSplits(Key key) {
        Text row = key.getRow();
        if (this.currentExtent == null || !this.currentExtent.contains((BinaryComparable)row)) {
            LoadPlan.TableSplits tableSplits = this.splitResolver.apply(row);
            KeyExtent extent = new KeyExtent(FAKE_ID, tableSplits.getEndRow(), tableSplits.getPrevRow());
            Preconditions.checkState((boolean)extent.contains((BinaryComparable)row), (String)"%s does not contain %s", (Object)tableSplits, (Object)row);
            if (this.currentExtent != null) {
                this.overlappingExtents.add(this.currentExtent);
            }
            this.currentExtent = extent;
        }
    }

    public void append(Key key) {
        if (this.splitResolver == null) {
            this.appendNoSplits(key);
        } else {
            this.appendSplits(key);
        }
        ++this.appended;
    }

    public void startLocalityGroup() {
        if (this.lgFirstRow != null) {
            if (this.firstRow == null) {
                this.firstRow = this.lgFirstRow;
                this.lastRow = this.lgLastRow;
            } else {
                this.firstRow = this.firstRow.compareTo((BinaryComparable)this.lgFirstRow) < 0 ? this.firstRow : this.lgFirstRow;
                this.lastRow = this.lastRow.compareTo((BinaryComparable)this.lgLastRow) > 0 ? this.lastRow : this.lgLastRow;
            }
            this.lgFirstRow = null;
            this.lgLastRow = null;
        }
    }

    public LoadPlan getLoadPlan(String filename) {
        Preconditions.checkState((boolean)this.finished, (Object)"Attempted to get load plan before closing");
        if (this.appended == 0L) {
            return LoadPlan.builder().build();
        }
        if (this.splitResolver == null) {
            return LoadPlan.builder().loadFileTo(filename, LoadPlan.RangeType.FILE, this.firstRow, this.lastRow).build();
        }
        LoadPlan.Builder builder = LoadPlan.builder();
        this.overlappingExtents.add(this.currentExtent);
        for (KeyExtent extent : this.overlappingExtents) {
            builder.loadFileTo(filename, LoadPlan.RangeType.TABLE, extent.prevEndRow(), extent.endRow());
        }
        return builder.build();
    }

    public void close() {
        this.finished = true;
        this.startLocalityGroup();
    }
}

