/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.format;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.function.Supplier;
import org.apache.accumulo.core.util.format.FormatterConfig;

public abstract class DateFormatSupplier
extends ThreadLocal<DateFormat>
implements Supplier<DateFormat> {
    private TimeZone timeZone;
    public static final String HUMAN_READABLE_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";

    public DateFormatSupplier() {
        this.timeZone = TimeZone.getDefault();
    }

    public DateFormatSupplier(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public DateFormat get() {
        DateFormat df = (DateFormat)super.get();
        df.setTimeZone(this.timeZone);
        return df;
    }

    public static DateFormatSupplier createDefaultFormatSupplier() {
        return new DateFormatSupplier(){

            @Override
            protected DateFormat initialValue() {
                return new FormatterConfig.DefaultDateFormat();
            }
        };
    }

    public static DateFormatSupplier createSimpleFormatSupplier(final String dateFormat) {
        return new DateFormatSupplier(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(dateFormat);
            }
        };
    }

    public static DateFormatSupplier createSimpleFormatSupplier(final String dateFormat, TimeZone timeZone) {
        return new DateFormatSupplier(timeZone){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(dateFormat);
            }
        };
    }
}

