/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.replication;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.server.replication.proto.Replication;

@Deprecated
public class StatusUtil {
    private static final Replication.Status INF_END_REPLICATION_STATUS;
    private static final Replication.Status CLOSED_STATUS;
    private static final Value INF_END_REPLICATION_STATUS_VALUE;
    private static final Value CLOSED_STATUS_VALUE;
    private static final Replication.Status.Builder CREATED_STATUS_BUILDER;

    public static Replication.Status ingestedUntil(long recordsIngested) {
        return StatusUtil.ingestedUntil(Replication.Status.newBuilder(), recordsIngested);
    }

    public static Replication.Status ingestedUntil(Replication.Status.Builder builder, long recordsIngested) {
        return StatusUtil.replicatedAndIngested(builder, 0L, recordsIngested);
    }

    public static Replication.Status replicated(long recordsReplicated) {
        return StatusUtil.replicated(Replication.Status.newBuilder(), recordsReplicated);
    }

    public static Replication.Status replicated(Replication.Status.Builder builder, long recordsReplicated) {
        return StatusUtil.replicatedAndIngested(builder, recordsReplicated, 0L);
    }

    public static Replication.Status replicatedAndIngested(long recordsReplicated, long recordsIngested) {
        return StatusUtil.replicatedAndIngested(Replication.Status.newBuilder(), recordsReplicated, recordsIngested);
    }

    public static Replication.Status replicatedAndIngested(Replication.Status.Builder builder, long recordsReplicated, long recordsIngested) {
        return builder.setBegin(recordsReplicated).setEnd(recordsIngested).setClosed(false).setInfiniteEnd(false).build();
    }

    public static synchronized Replication.Status fileCreated(long timeCreated) {
        CREATED_STATUS_BUILDER.setCreatedTime(timeCreated);
        return CREATED_STATUS_BUILDER.build();
    }

    public static Value fileCreatedValue(long timeCreated) {
        return ProtobufUtil.toValue((GeneratedMessageV3)StatusUtil.fileCreated(timeCreated));
    }

    public static Replication.Status fileClosed() {
        return CLOSED_STATUS;
    }

    public static Value fileClosedValue() {
        return CLOSED_STATUS_VALUE;
    }

    public static Replication.Status openWithUnknownLength(long timeCreated) {
        Replication.Status.Builder builder = Replication.Status.newBuilder();
        builder.setBegin(0L);
        builder.setEnd(0L);
        builder.setInfiniteEnd(true);
        builder.setClosed(false);
        builder.setCreatedTime(timeCreated);
        return builder.build();
    }

    public static Replication.Status openWithUnknownLength() {
        return INF_END_REPLICATION_STATUS;
    }

    public static Value openWithUnknownLengthValue() {
        return INF_END_REPLICATION_STATUS_VALUE;
    }

    public static Replication.Status fromValue(Value v) throws InvalidProtocolBufferException {
        return Replication.Status.parseFrom(v.get());
    }

    public static boolean isSafeForRemoval(Replication.Status status) {
        return status.getClosed() && StatusUtil.isFullyReplicated(status);
    }

    public static boolean isFullyReplicated(Replication.Status status) {
        if (status.getInfiniteEnd()) {
            return status.getBegin() == Long.MAX_VALUE;
        }
        return status.getBegin() >= status.getEnd();
    }

    public static boolean isWorkRequired(Replication.Status status) {
        if (status.getInfiniteEnd()) {
            return status.getBegin() != Long.MAX_VALUE;
        }
        return status.getBegin() < status.getEnd();
    }

    static {
        CREATED_STATUS_BUILDER = Replication.Status.newBuilder();
        CREATED_STATUS_BUILDER.setBegin(0L);
        CREATED_STATUS_BUILDER.setEnd(0L);
        CREATED_STATUS_BUILDER.setInfiniteEnd(false);
        CREATED_STATUS_BUILDER.setClosed(false);
        Replication.Status.Builder builder = Replication.Status.newBuilder();
        builder.setBegin(0L);
        builder.setEnd(0L);
        builder.setInfiniteEnd(true);
        builder.setClosed(false);
        INF_END_REPLICATION_STATUS = builder.build();
        INF_END_REPLICATION_STATUS_VALUE = ProtobufUtil.toValue((GeneratedMessageV3)INF_END_REPLICATION_STATUS);
        builder = Replication.Status.newBuilder();
        builder.setBegin(0L);
        builder.setEnd(0L);
        builder.setInfiniteEnd(true);
        builder.setClosed(true);
        CLOSED_STATUS = builder.build();
        CLOSED_STATUS_VALUE = ProtobufUtil.toValue((GeneratedMessageV3)CLOSED_STATUS);
    }
}

