/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.shiro.env;

import java.util.Map;
import org.apache.activemq.shiro.authz.ActiveMQPermissionResolver;
import org.apache.activemq.shiro.mgt.DefaultActiveMqSecurityManager;
import org.apache.shiro.authz.permission.PermissionResolver;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.config.Ini;
import org.apache.shiro.env.DefaultEnvironment;
import org.apache.shiro.ini.IniSecurityManagerFactory;
import org.apache.shiro.lang.ShiroException;
import org.apache.shiro.lang.io.ResourceUtils;
import org.apache.shiro.lang.util.Initializable;
import org.apache.shiro.lang.util.LifecycleUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.text.IniRealm;

public class IniEnvironment
extends DefaultEnvironment
implements Initializable {
    private Ini ini;
    private String iniConfig;
    private String iniResourePath;

    public IniEnvironment() {
    }

    public IniEnvironment(Ini ini) throws ShiroException {
        this.ini = ini;
        this.init();
    }

    public IniEnvironment(String iniConfig) {
        Ini ini = new Ini();
        ini.load(iniConfig);
        this.ini = ini;
        this.init();
    }

    public void setIni(Ini ini) {
        this.ini = ini;
    }

    public void setIniConfig(String config) {
        this.iniConfig = config;
    }

    public void setIniResourcePath(String iniResourcePath) {
        this.iniResourePath = iniResourcePath;
    }

    public void init() throws ShiroException {
        Ini ini = this.ini;
        if (ini != null) {
            this.apply(ini);
        }
        if (this.objects.isEmpty() && this.iniConfig != null) {
            ini = new Ini();
            ini.load(this.iniConfig);
            this.apply(ini);
        }
        if (this.objects.isEmpty() && this.iniResourePath != null) {
            ini = new Ini();
            ini.loadFromPath(this.iniResourePath);
            this.apply(ini);
        }
        if (this.objects.isEmpty() && ResourceUtils.resourceExists((String)"classpath:shiro.ini")) {
            ini = new Ini();
            ini.loadFromPath("classpath:shiro.ini");
            this.apply(ini);
        }
        if (this.objects.isEmpty()) {
            String msg = "Configuration error.  All heuristics for acquiring Shiro INI config have been exhausted.  Ensure you configure one of the following properties: 1) ini 2) iniConfig 3) iniResourcePath and the Ini sections are not empty.";
            throw new ConfigurationException(msg);
        }
        LifecycleUtils.init(this.objects.values());
    }

    protected void apply(Ini ini) {
        if (ini != null && !ini.isEmpty()) {
            Map<String, ?> objects = this.createObjects(ini);
            this.ini = ini;
            this.objects.clear();
            this.objects.putAll(objects);
        }
    }

    private Map<String, ?> createObjects(Ini ini) {
        IniSecurityManagerFactory factory = new IniSecurityManagerFactory(ini){

            protected SecurityManager createDefaultInstance() {
                return new DefaultActiveMqSecurityManager();
            }

            protected Realm createRealm(Ini ini) {
                IniRealm realm = (IniRealm)super.createRealm(ini);
                realm.setPermissionResolver((PermissionResolver)new ActiveMQPermissionResolver());
                return realm;
            }
        };
        factory.getInstance();
        return factory.getBeans();
    }
}

