/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeExtension;
import org.apache.camel.Message;
import org.apache.camel.SafeCopyProperty;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.AbstractExchange;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.trait.message.MessageTrait;
import org.apache.camel.trait.message.RedeliveryTraitPayload;

public class ExtendedExchangeExtension
implements ExchangeExtension {
    private final AbstractExchange exchange;
    private Boolean errorHandlerHandled;
    private boolean failureHandled;
    private Endpoint fromEndpoint;
    private String fromRouteId;
    private boolean streamCacheDisabled;
    private boolean redeliveryExhausted;
    private String historyNodeId;
    private String historyNodeSource;
    private String historyNodeLabel;
    private boolean transacted;
    private boolean notifyEvent;
    private boolean interruptable = true;
    private boolean interrupted;
    private boolean routeStop;
    private boolean rollbackOnly;
    private boolean rollbackOnlyLast;
    private AsyncCallback defaultConsumerCallback;
    private UnitOfWork unitOfWork;
    private List<Synchronization> onCompletions;
    private RedeliveryTraitPayload externalRedelivered = RedeliveryTraitPayload.UNDEFINED_REDELIVERY;

    ExtendedExchangeExtension(AbstractExchange exchange) {
        this.exchange = exchange;
    }

    public void setFromEndpoint(Endpoint fromEndpoint) {
        this.fromEndpoint = fromEndpoint;
    }

    public Endpoint getFromEndpoint() {
        return this.fromEndpoint;
    }

    public void setFromRouteId(String fromRouteId) {
        this.fromRouteId = fromRouteId;
    }

    public String getFromRouteId() {
        return this.fromRouteId;
    }

    public boolean isStreamCacheDisabled() {
        return this.streamCacheDisabled;
    }

    public void setStreamCacheDisabled(boolean streamCacheDisabled) {
        this.streamCacheDisabled = streamCacheDisabled;
    }

    public void addOnCompletion(Synchronization onCompletion) {
        if (this.unitOfWork == null) {
            if (this.onCompletions == null) {
                this.onCompletions = new ArrayList<Synchronization>();
            }
            this.onCompletions.add(onCompletion);
        } else {
            this.unitOfWork.addSynchronization(onCompletion);
        }
    }

    public boolean isErrorHandlerHandledSet() {
        return this.errorHandlerHandled != null;
    }

    public Boolean getErrorHandlerHandled() {
        return this.errorHandlerHandled;
    }

    public void setErrorHandlerHandled(Boolean errorHandlerHandled) {
        this.errorHandlerHandled = errorHandlerHandled;
    }

    public boolean isErrorHandlerHandled() {
        return this.errorHandlerHandled;
    }

    public boolean isRedeliveryExhausted() {
        return this.redeliveryExhausted;
    }

    public void setRedeliveryExhausted(boolean redeliveryExhausted) {
        this.redeliveryExhausted = redeliveryExhausted;
    }

    public void handoverCompletions(Exchange target) {
        if (this.onCompletions != null) {
            for (Synchronization onCompletion : this.onCompletions) {
                target.getExchangeExtension().addOnCompletion(onCompletion);
            }
            this.onCompletions.clear();
            this.onCompletions = null;
        } else if (this.unitOfWork != null) {
            this.unitOfWork.handoverSynchronization(target);
        }
    }

    public List<Synchronization> handoverCompletions() {
        ArrayList<Synchronization> answer = null;
        if (this.onCompletions != null) {
            answer = new ArrayList<Synchronization>(this.onCompletions);
            this.onCompletions.clear();
            this.onCompletions = null;
        }
        return answer;
    }

    public void setUnitOfWork(UnitOfWork unitOfWork) {
        this.unitOfWork = unitOfWork;
        if (unitOfWork != null && this.onCompletions != null) {
            for (Synchronization onCompletion : this.onCompletions) {
                unitOfWork.addSynchronization(onCompletion);
            }
            this.onCompletions.clear();
            this.onCompletions = null;
        }
    }

    public void copyInternalProperties(Exchange target) {
        this.exchange.copyInternalProperties(target);
    }

    public void setProperties(Map<String, Object> properties) {
        this.exchange.setProperties(properties);
    }

    public void setHistoryNodeId(String historyNodeId) {
        this.historyNodeId = historyNodeId;
    }

    public String getHistoryNodeId() {
        return this.historyNodeId;
    }

    public String getHistoryNodeSource() {
        return this.historyNodeSource;
    }

    public void setHistoryNodeSource(String historyNodeSource) {
        this.historyNodeSource = historyNodeSource;
    }

    public String getHistoryNodeLabel() {
        return this.historyNodeLabel;
    }

    public void setHistoryNodeLabel(String historyNodeLabel) {
        this.historyNodeLabel = historyNodeLabel;
    }

    public boolean isNotifyEvent() {
        return this.notifyEvent;
    }

    public void setNotifyEvent(boolean notifyEvent) {
        this.notifyEvent = notifyEvent;
    }

    public Map<String, Object> getInternalProperties() {
        return this.exchange.getInternalProperties();
    }

    public boolean containsOnCompletion(Synchronization onCompletion) {
        if (this.unitOfWork != null) {
            return this.unitOfWork.containsSynchronization(onCompletion);
        }
        return this.onCompletions != null && this.onCompletions.contains(onCompletion);
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    boolean isTransacted() {
        return this.transacted;
    }

    public void setInterruptable(boolean interruptable) {
        this.interruptable = interruptable;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean interrupted) {
        if (this.interruptable) {
            this.interrupted = interrupted;
        }
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public void setRollbackOnly(boolean rollbackOnly) {
        this.rollbackOnly = rollbackOnly;
    }

    public boolean isRollbackOnlyLast() {
        return this.rollbackOnlyLast;
    }

    public void setRollbackOnlyLast(boolean rollbackOnlyLast) {
        this.rollbackOnlyLast = rollbackOnlyLast;
    }

    public boolean isRouteStop() {
        return this.routeStop;
    }

    public void setRouteStop(boolean routeStop) {
        this.routeStop = routeStop;
    }

    public <T> T getInOrNull(Class<T> type) {
        return this.exchange.getInOrNull(type);
    }

    public AsyncCallback getDefaultConsumerCallback() {
        return this.defaultConsumerCallback;
    }

    public void setDefaultConsumerCallback(AsyncCallback callback) {
        this.defaultConsumerCallback = callback;
    }

    public void setSafeCopyProperty(String key, SafeCopyProperty value) {
        this.exchange.setSafeCopyProperty(key, value);
    }

    public <T> T getSafeCopyProperty(String key, Class<T> type) {
        return this.exchange.getSafeCopyProperty(key, type);
    }

    public void copySafeCopyPropertiesTo(ExchangeExtension target) {
        if (this.exchange.safeCopyProperties != null && !this.exchange.safeCopyProperties.isEmpty()) {
            this.exchange.safeCopyProperties.entrySet().stream().forEach(entry -> target.setSafeCopyProperty((String)entry.getKey(), ((SafeCopyProperty)entry.getValue()).safeCopy()));
        }
    }

    public boolean isFailureHandled() {
        return this.failureHandled;
    }

    public void setFailureHandled(boolean failureHandled) {
        this.failureHandled = failureHandled;
    }

    public boolean isExternalRedelivered(Message message) {
        if (this.externalRedelivered == RedeliveryTraitPayload.UNDEFINED_REDELIVERY) {
            this.externalRedelivered = (RedeliveryTraitPayload)message.getPayloadForTrait(MessageTrait.REDELIVERY);
        }
        return this.externalRedelivered == RedeliveryTraitPayload.IS_REDELIVERY;
    }

    UnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    public void reset() {
        if (this.unitOfWork != null) {
            this.unitOfWork.reset();
        }
        if (this.onCompletions != null) {
            this.onCompletions.clear();
        }
        if (this.exchange.variableRepository != null) {
            this.exchange.variableRepository.clear();
        }
        this.externalRedelivered = RedeliveryTraitPayload.UNDEFINED_REDELIVERY;
        this.setHistoryNodeId(null);
        this.setHistoryNodeLabel(null);
        this.setTransacted(false);
        this.setNotifyEvent(false);
        this.setInterrupted(false);
        this.setInterruptable(true);
        this.setRedeliveryExhausted(false);
        this.setErrorHandlerHandled(null);
        this.setStreamCacheDisabled(false);
        this.setRollbackOnly(false);
        this.setRollbackOnlyLast(false);
        this.setRouteStop(false);
    }

    public Exchange createCopyWithProperties(CamelContext context) {
        DefaultExchange answer = new DefaultExchange(context, this.exchange.internalProperties, this.exchange.properties);
        answer.setPattern(this.exchange.pattern);
        return answer;
    }
}

