/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.ProtonJEndpoint;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.engine.impl.ConnectionImpl;
import org.apache.qpid.proton.engine.impl.RecordImpl;
import org.apache.qpid.proton.engine.impl.TransportImpl;

public abstract class EndpointImpl
implements ProtonJEndpoint {
    private EndpointState _localState = EndpointState.UNINITIALIZED;
    private EndpointState _remoteState = EndpointState.UNINITIALIZED;
    private ErrorCondition _localError = new ErrorCondition();
    private ErrorCondition _remoteError = new ErrorCondition();
    private boolean _modified;
    private EndpointImpl _transportNext;
    private EndpointImpl _transportPrev;
    private Object _context;
    private Record _attachments = new RecordImpl();
    private int refcount = 1;
    boolean freed = false;

    void incref() {
        ++this.refcount;
    }

    void decref() {
        --this.refcount;
        if (this.refcount == 0) {
            this.postFinal();
        } else if (this.refcount < 0) {
            throw new IllegalStateException();
        }
    }

    abstract void postFinal();

    abstract void localOpen();

    abstract void localClose();

    @Override
    public void open() {
        if (this.getLocalState() != EndpointState.ACTIVE) {
            this._localState = EndpointState.ACTIVE;
            this.localOpen();
            this.modified();
        }
    }

    @Override
    public void close() {
        if (this.getLocalState() != EndpointState.CLOSED) {
            this._localState = EndpointState.CLOSED;
            this.localClose();
            this.modified();
        }
    }

    @Override
    public EndpointState getLocalState() {
        return this._localState;
    }

    @Override
    public EndpointState getRemoteState() {
        return this._remoteState;
    }

    @Override
    public ErrorCondition getCondition() {
        return this._localError;
    }

    @Override
    public void setCondition(ErrorCondition condition) {
        if (condition != null) {
            this._localError.copyFrom(condition);
        } else {
            this._localError.clear();
        }
    }

    @Override
    public ErrorCondition getRemoteCondition() {
        return this._remoteError;
    }

    void setLocalState(EndpointState localState) {
        this._localState = localState;
    }

    void setRemoteState(EndpointState remoteState) {
        this._remoteState = remoteState;
    }

    void modified() {
        this.modified(true);
    }

    void modified(boolean emit) {
        ConnectionImpl conn;
        TransportImpl trans;
        if (!this._modified) {
            this._modified = true;
            this.getConnectionImpl().addModified(this);
        }
        if (emit && (trans = (conn = this.getConnectionImpl()).getTransport()) != null) {
            conn.put(Event.Type.TRANSPORT, trans);
        }
    }

    protected abstract ConnectionImpl getConnectionImpl();

    void clearModified() {
        if (this._modified) {
            this._modified = false;
            this.getConnectionImpl().removeModified(this);
        }
    }

    boolean isModified() {
        return this._modified;
    }

    EndpointImpl transportNext() {
        return this._transportNext;
    }

    EndpointImpl transportPrev() {
        return this._transportPrev;
    }

    abstract void doFree();

    @Override
    public final void free() {
        if (this.freed) {
            return;
        }
        this.freed = true;
        this.doFree();
        this.decref();
    }

    void setTransportNext(EndpointImpl transportNext) {
        this._transportNext = transportNext;
    }

    void setTransportPrev(EndpointImpl transportPrevious) {
        this._transportPrev = transportPrevious;
    }

    @Override
    public Object getContext() {
        return this._context;
    }

    @Override
    public void setContext(Object context) {
        this._context = context;
    }

    @Override
    public Record attachments() {
        return this._attachments;
    }
}

