/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.HexFormat;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.DivertBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerAddressPlugin;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationAddressBindingsConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationAddressConduitConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumerConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumerManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationGenericConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationLocalPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicySupport;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AMQPFederationAddressPolicyManager
extends AMQPFederationLocalPolicyManager
implements ActiveMQServerAddressPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String OPPOSING_PEER_MATCHING_TEMPLATE = "^federation\\..+?\\.policy\\..+?\\.address\\..+?\\.node\\.%s$";
    protected final String baseConsumerFilter;
    protected final FederationReceiveFromAddressPolicy policy;
    protected final Map<String, AMQPFederationAddressConsumerRegistry> addressTracking = new HashMap<String, AMQPFederationAddressConsumerRegistry>();
    protected final Map<DivertBinding, Set<QueueBinding>> divertsTracking = new HashMap<DivertBinding, Set<QueueBinding>>();
    private Pattern opposingPeerBindingPattern;

    public AMQPFederationAddressPolicyManager(AMQPFederation federation, AMQPFederationMetrics metrics, FederationReceiveFromAddressPolicy addressPolicy) throws ActiveMQException {
        super(federation, metrics, addressPolicy);
        Objects.requireNonNull(addressPolicy, "The Address match policy cannot be null");
        this.policy = addressPolicy;
        this.baseConsumerFilter = AMQPFederationPolicySupport.generateAddressFilter(this.policy.getMaxHops());
    }

    @Override
    public FederationReceiveFromAddressPolicy getPolicy() {
        return this.policy;
    }

    @Override
    protected void updateStateAfterConnect(AMQPFederationConsumerConfiguration configuration, AMQPSessionContext session) {
        String remoteNodeId = session.getSession().getConnection().getRemoteContainer();
        this.opposingPeerBindingPattern = Pattern.compile(String.format(OPPOSING_PEER_MATCHING_TEMPLATE, Pattern.quote(remoteNodeId)));
    }

    @Override
    protected void safeCleanupManagerResources(boolean force) {
        try {
            this.addressTracking.values().forEach(registry -> {
                if (registry != null) {
                    if (this.isConnected() && !force) {
                        registry.shutdown();
                    } else {
                        registry.shutdownNow();
                    }
                }
            });
        }
        finally {
            this.addressTracking.clear();
            this.divertsTracking.clear();
        }
    }

    public synchronized void afterRemoveAddress(SimpleString address, AddressInfo addressInfo) throws ActiveMQException {
        AMQPFederationAddressConsumerRegistry registry;
        if (this.isActive() && (registry = this.addressTracking.remove(address.toString())) != null) {
            logger.trace("Federated address {} was removed, closing federation consumer", (Object)address);
            registry.shutdownNow();
        }
    }

    public synchronized void afterRemoveBinding(Binding binding, Transaction tx, boolean deleteData) throws ActiveMQException {
        if (this.isActive()) {
            DivertBinding divert;
            if (binding instanceof QueueBinding) {
                AMQPFederationAddressConsumerRegistry registry = this.addressTracking.get(binding.getAddress().toString());
                logger.trace("Federated address {} binding was removed, reducing demand.", (Object)binding.getAddress());
                if (registry != null) {
                    this.tryRemoveDemandOnAddress(registry, binding);
                } else if (this.policy.isEnableDivertBindings()) {
                    this.divertsTracking.entrySet().forEach(divertEntry -> {
                        String sourceAddress = ((DivertBinding)divertEntry.getKey()).getAddress().toString();
                        SimpleString forwardAddress = ((DivertBinding)divertEntry.getKey()).getDivert().getForwardAddress();
                        if (AMQPFederationAddressPolicyManager.isAddressInDivertForwards(binding.getAddress(), forwardAddress)) {
                            ((Set)divertEntry.getValue()).remove(binding);
                            if (((Set)divertEntry.getValue()).isEmpty()) {
                                this.tryRemoveDemandOnAddress(this.addressTracking.get(sourceAddress), (Binding)divertEntry.getKey());
                            }
                        }
                    });
                }
            } else if (this.policy.isEnableDivertBindings() && binding instanceof DivertBinding && this.divertsTracking.remove(divert = (DivertBinding)binding) != null) {
                try {
                    this.tryRemoveDemandOnAddress(this.addressTracking.get(divert.getAddress().toString()), (Binding)divert);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.federationBindingsLookupError(divert.getDivert().getForwardAddress(), (Throwable)e);
                }
            }
        }
    }

    private void tryRemoveDemandOnAddress(AMQPFederationAddressConsumerRegistry registry, Binding binding) {
        if (registry != null) {
            logger.trace("Reducing demand on federated address {}", (Object)registry.getAddress());
            registry.removeDemand(binding);
        }
    }

    @Override
    protected void scanAllBindings() {
        this.server.getPostOffice().getAllBindings().filter(binding -> binding instanceof QueueBinding || this.policy.isEnableDivertBindings() && binding instanceof DivertBinding).forEach(binding -> this.afterAddBinding((Binding)binding));
    }

    public synchronized void afterAddAddress(AddressInfo addressInfo, boolean reload) {
        if (this.isActive() && this.policy.isEnableDivertBindings() && this.policy.test(addressInfo)) {
            try {
                this.server.getPostOffice().getDirectBindings(addressInfo.getName()).stream().filter(binding -> binding instanceof DivertBinding).forEach(this::checkBindingForMatch);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.federationBindingsLookupError(addressInfo.getName(), (Throwable)e);
            }
        }
    }

    public synchronized void afterAddBinding(Binding binding) {
        if (this.isActive()) {
            this.checkBindingForMatch(binding);
        }
    }

    private void checkBindingForMatch(Binding binding) {
        if (binding instanceof QueueBinding) {
            QueueBinding queueBinding = (QueueBinding)binding;
            AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(binding.getAddress());
            logger.trace("Binding Added on address: {}, filter={}", (Object)queueBinding.getAddress(), (Object)queueBinding.getFilter());
            if (this.testIfAddressMatchesPolicy(addressInfo)) {
                if (this.isPluginBlockingFederationConsumerCreate(queueBinding.getQueue())) {
                    return;
                }
                if (this.isBindingFromOpposingFederationTarget(queueBinding)) {
                    return;
                }
                this.createOrUpdateFederatedAddressConsumerForBinding(addressInfo, (Binding)queueBinding);
            } else {
                this.reactIfQueueBindingMatchesAnyDivertTarget(queueBinding);
            }
        } else if (binding instanceof DivertBinding) {
            DivertBinding divertBinding = (DivertBinding)binding;
            this.reactIfAnyQueueBindingMatchesDivertTarget(divertBinding);
        }
    }

    private boolean isBindingFromOpposingFederationTarget(QueueBinding queueBinding) {
        String queueName = queueBinding.getQueue().getName().toString();
        return this.opposingPeerBindingPattern.matcher(queueName).matches();
    }

    private void reactIfAnyQueueBindingMatchesDivertTarget(DivertBinding divertBinding) {
        if (!this.policy.isEnableDivertBindings()) {
            return;
        }
        AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(divertBinding.getAddress());
        if (!this.testIfAddressMatchesPolicy(addressInfo)) {
            return;
        }
        if (!this.divertsTracking.containsKey(divertBinding)) {
            HashSet matchingQueues = new HashSet();
            this.divertsTracking.put(divertBinding, matchingQueues);
            SimpleString forwardAddress = divertBinding.getDivert().getForwardAddress();
            SimpleString[] forwardAddresses = forwardAddress.split(',');
            try {
                for (SimpleString forward : forwardAddresses) {
                    this.server.getPostOffice().getBindingsForAddress(forward).getBindings().stream().filter(b -> b instanceof QueueBinding).map(b -> (QueueBinding)b).forEach(queueBinding -> {
                        if (this.isPluginBlockingFederationConsumerCreate(divertBinding.getDivert(), queueBinding.getQueue())) {
                            return;
                        }
                        if (this.isPluginBlockingFederationConsumerCreate(queueBinding.getQueue())) {
                            return;
                        }
                        matchingQueues.add(queueBinding);
                        this.createOrUpdateFederatedAddressConsumerForBinding(addressInfo, (Binding)divertBinding);
                    });
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.federationBindingsLookupError(forwardAddress, (Throwable)e);
            }
        }
    }

    private void reactIfQueueBindingMatchesAnyDivertTarget(QueueBinding queueBinding) {
        if (!this.policy.isEnableDivertBindings()) {
            return;
        }
        SimpleString queueAddress = queueBinding.getAddress();
        this.divertsTracking.entrySet().forEach(e -> {
            SimpleString forwardAddress = ((DivertBinding)e.getKey()).getDivert().getForwardAddress();
            DivertBinding divertBinding = (DivertBinding)e.getKey();
            if (!((Set)e.getValue()).contains(queueBinding) && AMQPFederationAddressPolicyManager.isAddressInDivertForwards(queueAddress, forwardAddress)) {
                if (this.isPluginBlockingFederationConsumerCreate(divertBinding.getDivert(), queueBinding.getQueue())) {
                    return;
                }
                if (this.isPluginBlockingFederationConsumerCreate(queueBinding.getQueue())) {
                    return;
                }
                ((Set)e.getValue()).add(queueBinding);
                AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(divertBinding.getAddress());
                this.createOrUpdateFederatedAddressConsumerForBinding(addressInfo, (Binding)divertBinding);
            }
        });
    }

    private void createOrUpdateFederatedAddressConsumerForBinding(AddressInfo addressInfo, Binding binding) {
        AMQPFederationAddressConsumerRegistry consumerRegistry;
        logger.trace("Federation Address Policy matched on for demand on address: {} : binding: {}", (Object)addressInfo, (Object)binding);
        String addressName = addressInfo.getName().toString();
        if (this.addressTracking.containsKey(addressName)) {
            consumerRegistry = this.addressTracking.get(addressName);
        } else {
            consumerRegistry = new AMQPFederationAddressConsumerRegistry(this, addressInfo);
            this.addressTracking.put(addressName, consumerRegistry);
        }
        consumerRegistry.addDemand(binding);
    }

    synchronized void afterRemoteAddressAdded(String addressName) throws Exception {
        AMQPFederationAddressConsumerRegistry consumerRegistry;
        if (this.isActive() && this.testIfAddressMatchesPolicy(addressName, RoutingType.MULTICAST) && (consumerRegistry = this.addressTracking.get(addressName)) != null) {
            consumerRegistry.recover();
        }
    }

    private boolean testIfAddressMatchesPolicy(AddressInfo addressInfo) {
        if (!this.policy.test(addressInfo)) {
            return false;
        }
        if (this.configuration.getReceiverCredits() <= 0) {
            logger.debug("Federation address policy rejecting match on {} because credit is set to zero:", (Object)addressInfo.getName());
            return false;
        }
        return true;
    }

    private boolean testIfAddressMatchesPolicy(String address, RoutingType type) {
        return this.policy.test(address, type);
    }

    private static boolean isAddressInDivertForwards(SimpleString targetAddress, SimpleString forwardAddress) {
        SimpleString[] forwardAddresses;
        for (SimpleString forward : forwardAddresses = forwardAddress.split(',')) {
            if (!targetAddress.equals((Object)forward)) continue;
            return true;
        }
        return false;
    }

    private static String generateFilterId(String filterString) {
        byte[] filterUTF8 = filterString.getBytes(StandardCharsets.UTF_8);
        try {
            return filterString.hashCode() + "." + HexFormat.of().formatHex(MessageDigest.getInstance("SHA-256").digest(filterUTF8));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Could not create filter ID SHA, enable ignore address filters required to create federation consumers", e);
        }
    }

    private static class AMQPFederationAddressConsumerRegistry {
        private final AMQPFederationConsumerKey unfilteredConsumerKey;
        private final AMQPFederationAddressPolicyManager manager;
        private final Map<AMQPFederationConsumerKey, AMQPFederationAddressConsumerManager<?>> registry = new HashMap();
        private final AddressInfo addressInfo;
        private final String baseConsumerFilter;
        private final AMQPFederationConsumerConfiguration configuration;

        AMQPFederationAddressConsumerRegistry(AMQPFederationAddressPolicyManager manager, AddressInfo addressInfo) {
            this.manager = manager;
            this.addressInfo = addressInfo;
            this.baseConsumerFilter = manager.baseConsumerFilter;
            this.configuration = manager.configuration;
            this.unfilteredConsumerKey = new AMQPFederationConsumerKey(addressInfo.getName().toString());
        }

        public void removeDemand(Binding binding) {
            AMQPFederationConsumerKey key = this.createConsumerKey(binding);
            AMQPFederationAddressConsumerManager<?> manager = this.registry.get(key);
            if (manager != null) {
                manager.removeDemand(binding);
            }
        }

        public void addDemand(Binding binding) {
            AMQPFederationConsumerKey key = this.createConsumerKey(binding);
            AMQPFederationAddressConsumerManager consumerManager = this.registry.get(key);
            if (consumerManager == null) {
                if (this.isUseConduitConsumer()) {
                    consumerManager = new AMQPFederationAddressConduitConsumerManager(this.manager, this.createConsumerInfo(this.addressInfo, binding), this.addressInfo);
                    this.registry.put(key, consumerManager);
                } else {
                    consumerManager = new AMQPFederationAddressBindingsConsumerManager(this.manager, this.createConsumerInfo(this.addressInfo, binding), this.addressInfo);
                    this.registry.put(key, consumerManager);
                }
            }
            consumerManager.addDemand(binding);
        }

        public String getAddress() {
            return this.addressInfo.getName().toString();
        }

        public void recover() {
            this.registry.values().forEach(entry -> {
                if (entry != null) {
                    entry.recover();
                }
            });
        }

        public void shutdown() {
            this.registry.values().forEach(entry -> {
                if (entry != null) {
                    entry.shutdown();
                }
            });
        }

        public void shutdownNow() {
            this.registry.values().forEach(entry -> {
                if (entry != null) {
                    entry.shutdownNow();
                }
            });
        }

        private AMQPFederationConsumerKey createConsumerKey(Binding binding) {
            if (this.isUseConduitConsumer() || binding.getFilter() == null) {
                return this.unfilteredConsumerKey;
            }
            return new AMQPFederationConsumerKey(binding.getAddress().toString(), binding.getFilter());
        }

        private FederationConsumerInfo createConsumerInfo(AddressInfo address, Binding binding) {
            String addressName = address.getName().toString();
            boolean ignoreBindingFilters = this.isUseConduitConsumer() || binding.getFilter() == null;
            String generatedQueueName = this.generateQueueName(address, binding, ignoreBindingFilters);
            Object consumerFilter = ignoreBindingFilters ? this.baseConsumerFilter : (this.baseConsumerFilter != null ? "(" + String.valueOf(binding.getFilter().getFilterString()) + ") AND " + this.baseConsumerFilter : binding.getFilter().getFilterString().toString());
            return new AMQPFederationGenericConsumerInfo(FederationConsumerInfo.Role.ADDRESS_CONSUMER, addressName, generatedQueueName, address.getRoutingType(), (String)consumerFilter, CompositeAddress.toFullyQualified((String)addressName, (String)generatedQueueName), ActiveMQDefaultConfiguration.getDefaultConsumerPriority());
        }

        private boolean isUseConduitConsumer() {
            return this.configuration.isIgnoreAddressBindingFilters() || !this.manager.getFederation().getCapabilities().isUseFQQNAddressSubscriptions();
        }

        private String generateQueueName(AddressInfo address, Binding binding, boolean ignoreFilters) {
            if (ignoreFilters) {
                return "federation." + this.manager.getFederation().getName() + ".policy." + this.manager.getPolicyName() + ".address." + String.valueOf(address.getName()) + ".node." + String.valueOf(this.manager.server.getNodeID());
            }
            return "federation." + this.manager.getFederation().getName() + ".policy." + this.manager.getPolicyName() + ".address." + String.valueOf(address.getName()) + ".filterId." + AMQPFederationAddressPolicyManager.generateFilterId(binding.getFilter().getFilterString().toString()) + ".node." + String.valueOf(this.manager.server.getNodeID());
        }
    }

    private static class AMQPFederationAddressBindingsConsumerManager
    extends AMQPFederationAddressConsumerManager<AMQPFederationAddressBindingsConsumer> {
        AMQPFederationAddressBindingsConsumerManager(AMQPFederationAddressPolicyManager manager, FederationConsumerInfo consumerInfo, AddressInfo addressInfo) {
            super(manager, consumerInfo, addressInfo);
        }

        @Override
        protected AMQPFederationAddressBindingsConsumer createFederationConsumer(Set<Binding> demand) {
            if (logger.isTraceEnabled()) {
                logger.trace("AMQP Federation {} creating address consumer: {} for policy: {}", new Object[]{this.federation.getName(), this.consumerInfo, this.policy.getPolicyName()});
            }
            AMQPFederationAddressBindingsConsumer consumer = new AMQPFederationAddressBindingsConsumer(this.manager, this.manager.getConfiguration(), this.federation.getSessionContext(), this.consumerInfo, this.manager.getMetrics().newConsumerMetrics());
            consumer.addBindings(demand);
            return consumer;
        }

        @Override
        protected void whenDemandTrackingEntryAdded(Binding binding, AMQPFederationAddressBindingsConsumer consumer) {
            if (consumer != null) {
                consumer.addBinding(binding);
            }
        }

        @Override
        protected void whenDemandTrackingEntryRemoved(Binding binding, AMQPFederationAddressBindingsConsumer consumer) {
            if (consumer != null) {
                consumer.removeBinding(binding);
            }
        }
    }

    private static class AMQPFederationAddressConduitConsumerManager
    extends AMQPFederationAddressConsumerManager<AMQPFederationAddressConduitConsumer> {
        AMQPFederationAddressConduitConsumerManager(AMQPFederationAddressPolicyManager manager, FederationConsumerInfo consumerInfo, AddressInfo addressInfo) {
            super(manager, consumerInfo, addressInfo);
        }

        @Override
        protected AMQPFederationAddressConduitConsumer createFederationConsumer(Set<Binding> demand) {
            if (logger.isTraceEnabled()) {
                logger.trace("AMQP Federation {} creating address consumer: {} for policy: {}", new Object[]{this.federation.getName(), this.consumerInfo, this.policy.getPolicyName()});
            }
            return new AMQPFederationAddressConduitConsumer(this.manager, this.manager.getConfiguration(), this.federation.getSessionContext(), this.consumerInfo, this.manager.getMetrics().newConsumerMetrics());
        }
    }

    private static abstract class AMQPFederationAddressConsumerManager<Consumer extends AMQPFederationConsumer>
    extends AMQPFederationConsumerManager<Binding, Consumer> {
        protected final AMQPFederation federation;
        protected final AMQPFederationAddressPolicyManager manager;
        protected final FederationReceiveFromAddressPolicy policy;
        protected final AddressInfo addressInfo;
        protected final FederationConsumerInfo consumerInfo;

        AMQPFederationAddressConsumerManager(AMQPFederationAddressPolicyManager manager, FederationConsumerInfo consumerInfo, AddressInfo addressInfo) {
            super(manager);
            this.manager = manager;
            this.federation = manager.getFederation();
            this.policy = manager.getPolicy();
            this.addressInfo = addressInfo;
            this.consumerInfo = consumerInfo;
        }

        @Override
        protected boolean isPluginBlockingFederationConsumerCreate() {
            return this.manager.isPluginBlockingFederationConsumerCreate(this.addressInfo);
        }

        @Override
        protected void whenDemandTrackingEntryAdded(Binding entry, Consumer consumer) {
        }

        @Override
        protected void whenDemandTrackingEntryRemoved(Binding entry, Consumer consumer) {
        }
    }

    private static class AMQPFederationConsumerKey {
        private final String address;
        private final Filter filter;

        AMQPFederationConsumerKey(String address) {
            this(address, null);
        }

        AMQPFederationConsumerKey(String address, Filter filter) {
            this.address = Objects.requireNonNull(address);
            this.filter = filter;
        }

        public int hashCode() {
            return Objects.hashCode(this.address) + Objects.hashCode(this.filter);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AMQPFederationConsumerKey other = (AMQPFederationConsumerKey)obj;
            return Objects.equals(this.address, other.address) && Objects.equals(this.filter, other.filter);
        }
    }
}

