/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationRemotePolicyControl;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationRemotePolicyManager;

public class AMQPFederationRemotePolicyControlType
extends AbstractControl
implements AMQPFederationRemotePolicyControl {
    private final AMQPFederationRemotePolicyManager manager;

    public AMQPFederationRemotePolicyControlType(ActiveMQServer server, AMQPFederationRemotePolicyManager manager) throws NotCompliantMBeanException {
        super(AMQPFederationRemotePolicyControl.class, server.getStorageManager());
        this.manager = manager;
    }

    @Override
    public String getType() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getType((Object)this.manager);
        }
        this.clearIO();
        try {
            String string = this.manager.getPolicyType().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getName((Object)this.manager);
        }
        this.clearIO();
        try {
            String string = this.manager.getPolicyName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getMessagesSent() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesSent((Object)this.manager);
        }
        this.clearIO();
        try {
            long l = this.manager.getMetrics().getMessagesSent();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(AMQPFederationRemotePolicyControl.class);
    }

    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(AMQPFederationRemotePolicyControl.class);
    }
}

