/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersisterV2;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPStandardMessage;

public class AMQPMessagePersisterV3
extends AMQPMessagePersisterV2 {
    public static final byte ID = 5;
    public static AMQPMessagePersisterV3 theInstance;

    public static AMQPMessagePersisterV3 getInstance() {
        if (theInstance == null) {
            theInstance = new AMQPMessagePersisterV3();
        }
        return theInstance;
    }

    @Override
    public byte getID() {
        return 5;
    }

    @Override
    public int getEncodeSize(Message record) {
        int encodeSize = super.getEncodeSize(record) + 8;
        return encodeSize;
    }

    @Override
    public void encode(ActiveMQBuffer buffer, Message record) {
        super.encode(buffer, record);
        buffer.writeLong(record.getExpiration());
    }

    @Override
    public Message decode(ActiveMQBuffer buffer, Message ignore, CoreMessageObjectPools pool) {
        Message record = super.decode(buffer, ignore, pool);
        assert (record != null && AMQPStandardMessage.class.equals((Object)record.getClass()));
        ((AMQPStandardMessage)record).reloadExpiration(buffer.readLong());
        return record;
    }
}

