% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record-batch.R
\name{as_record_batch}
\alias{as_record_batch}
\alias{as_record_batch.RecordBatch}
\alias{as_record_batch.Table}
\alias{as_record_batch.arrow_dplyr_query}
\alias{as_record_batch.data.frame}
\title{Convert an object to an Arrow RecordBatch}
\usage{
as_record_batch(x, ..., schema = NULL)

\method{as_record_batch}{RecordBatch}(x, ..., schema = NULL)

\method{as_record_batch}{Table}(x, ..., schema = NULL)

\method{as_record_batch}{arrow_dplyr_query}(x, ...)

\method{as_record_batch}{data.frame}(x, ..., schema = NULL)
}
\arguments{
\item{x}{An object to convert to an Arrow RecordBatch}

\item{...}{Passed to S3 methods}

\item{schema}{a \link{Schema}, or \code{NULL} (the default) to infer the schema from
the data in \code{...}. When providing an Arrow IPC buffer, \code{schema} is required.}
}
\value{
A \link{RecordBatch}
}
\description{
Whereas \code{\link[=record_batch]{record_batch()}} constructs a \link{RecordBatch} from one or more columns,
\code{as_record_batch()} converts a single object to an Arrow \link{RecordBatch}.
}
\examples{
# use as_record_batch() for a single object
as_record_batch(data.frame(col1 = 1, col2 = "two"))

# use record_batch() to create from columns
record_batch(col1 = 1, col2 = "two")

}
