/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.core.validator;

import java.util.List;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.Statement;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionSchemaValidator
implements Validator<Assertion> {
    public void validate(Assertion assertion) throws ValidationException {
        this.validateVersion(assertion);
        this.validateId(assertion);
        this.validateIssuer(assertion);
        this.validateIssueInstant(assertion);
        this.validateStatements(assertion);
    }

    protected void validateVersion(Assertion assertion) throws ValidationException {
        if (assertion.getMajorVersion() != 1 && (assertion.getMinorVersion() != 0 || assertion.getMinorVersion() != 1)) {
            throw new ValidationException("Invalid Version");
        }
    }

    protected void validateId(Assertion assertion) throws ValidationException {
        if (DatatypeHelper.isEmpty((String)assertion.getID())) {
            throw new ValidationException("ID not present");
        }
    }

    protected void validateIssuer(Assertion assertion) throws ValidationException {
        if (DatatypeHelper.isEmpty((String)assertion.getIssuer())) {
            throw new ValidationException("Issuer not present");
        }
    }

    protected void validateIssueInstant(Assertion assertion) throws ValidationException {
        if (assertion.getIssueInstant() == null) {
            throw new ValidationException("IssueInstant not present");
        }
    }

    protected void validateStatements(Assertion assertion) throws ValidationException {
        List<Statement> list = assertion.getStatements();
        if (list == null || list.size() == 0) {
            throw new ValidationException("No Statements present");
        }
    }
}

