/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.polling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.AcknowledgementManager;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.workers.SandeshaThread;
import org.apache.sandesha2.workers.SequenceEntry;

public class PollingManager
extends SandeshaThread {
    private static final Log log = LogFactory.getLog(PollingManager.class);
    private int nextIndex = 0;
    private LinkedList<SequenceEntry> scheduledPollingRequests = new LinkedList();
    private static final int POLLING_MANAGER_WAIT_TIME = 3000;
    private HashMap<String, Long> pollTimes = new HashMap();

    public PollingManager() {
        super(3000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalRun() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: PollingManager::internalRun");
        }
        Transaction t = null;
        try {
            boolean forcePoll = false;
            SequenceEntry entry = null;
            PollingManager pollingManager = this;
            synchronized (pollingManager) {
                if (!this.scheduledPollingRequests.isEmpty()) {
                    entry = this.scheduledPollingRequests.removeFirst();
                    forcePoll = true;
                }
            }
            if (entry == null) {
                ArrayList<SequenceEntry> allSequencesList = this.getSequences();
                int size = allSequencesList.size();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Choosing one from " + size + " sequences"));
                }
                if (this.nextIndex >= size) {
                    this.nextIndex = 0;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Exit: PollingManager::internalRun, looped over all sequences, sleeping");
                    }
                    boolean bl = true;
                    return bl;
                }
                entry = allSequencesList.get(this.nextIndex++);
                long now = System.currentTimeMillis();
                Long time = this.pollTimes.get(entry.getSequenceId());
                if (time != null && now - time < 3000L) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Exit: PollingManager::internalRun, skipping sequence, not sleeping");
                    }
                    boolean bl = false;
                    return bl;
                }
                this.pollTimes.put(entry.getSequenceId(), new Long(now));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Chose sequence " + entry.getSequenceId()));
            }
            t = this.storageManager.getTransaction();
            if (entry.isRmSource()) {
                this.pollRMSSide(entry, forcePoll);
            } else {
                this.pollRMDSide(entry, forcePoll);
            }
            if (t != null) {
                t.commit();
            }
            t = null;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception", (Throwable)e);
            }
        }
        finally {
            block36: {
                if (t != null && t.isActive()) {
                    try {
                        t.rollback();
                    }
                    catch (Exception e2) {
                        if (!log.isDebugEnabled()) break block36;
                        log.debug((Object)"Exception during rollback", (Throwable)e2);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: PollingManager::internalRun, not sleeping");
        }
        return false;
    }

    private void pollRMSSide(SequenceEntry entry, boolean force) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: PollingManager::pollRMSSide, force: " + force));
        }
        RMSBeanMgr rmsBeanManager = this.storageManager.getRMSBeanMgr();
        RMSBean findRMS = new RMSBean();
        findRMS.setInternalSequenceID(entry.getSequenceId());
        findRMS.setPollingMode(true);
        findRMS.setTerminated(false);
        RMSBean beanToPoll = rmsBeanManager.findUnique(findRMS);
        if (beanToPoll == null) {
            this.stopThreadForSequence(entry.getSequenceId(), true);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Polling rms " + beanToPoll));
            }
            boolean cleanAcks = true;
            boolean waitingForTerminateSeqResponse = false;
            long repliesExpected = 0L;
            if (!force && beanToPoll.getNextMessageNumber() > -1L && (cleanAcks = AcknowledgementManager.verifySequenceCompletion(beanToPoll.getClientCompletedMessages(), beanToPoll.getNextMessageNumber())) && (repliesExpected = beanToPoll.getExpectedReplies()) == 0L && !beanToPoll.isTerminated() && beanToPoll.isTerminateAdded()) {
                waitingForTerminateSeqResponse = true;
            }
            if (beanToPoll.getSequenceID() != null) {
                if ((force || !cleanAcks || repliesExpected > 0L || waitingForTerminateSeqResponse) && beanToPoll.getReferenceMessageStoreKey() != null) {
                    this.pollForSequence(beanToPoll.getAnonymousUUID(), beanToPoll.getInternalSequenceID(), beanToPoll.getReferenceMessageStoreKey(), beanToPoll, entry);
                }
            } else {
                this.pollForSequence(beanToPoll.getAnonymousUUID(), beanToPoll.getInternalSequenceID(), beanToPoll.getReferenceMessageStoreKey(), beanToPoll, entry);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: PollingManager::pollRMSSide");
        }
    }

    private void pollRMDSide(SequenceEntry entry, boolean force) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: PollingManager::pollRMDSide, force: " + force));
        }
        RMDBeanMgr nextMsgMgr = this.storageManager.getRMDBeanMgr();
        RMDBean findBean = new RMDBean();
        findBean.setPollingMode(true);
        findBean.setTerminated(false);
        findBean.setSequenceID(entry.getSequenceId());
        RMDBean nextMsgBean = nextMsgMgr.findUnique(findBean);
        if (nextMsgBean == null) {
            this.stopThreadForSequence(entry.getSequenceId(), false);
        } else {
            boolean doPoll = true;
            String outboundSequence = nextMsgBean.getOutboundInternalSequence();
            if (outboundSequence != null) {
                RMSBean findRMS = new RMSBean();
                findRMS.setInternalSequenceID(outboundSequence);
                findRMS.setTerminated(false);
                RMSBeanMgr mgr = this.storageManager.getRMSBeanMgr();
                RMSBean outbound = mgr.findUnique(findRMS);
                if (outbound != null && outbound.getExpectedReplies() == 0L) {
                    doPoll = false;
                }
            }
            if (force || doPoll) {
                this.pollForSequence(null, null, nextMsgBean.getReferenceMessageKey(), nextMsgBean, entry);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: PollingManager::pollRMDSide");
        }
    }

    private void pollForSequence(String anonUUID, String internalSeqId, String referenceMsgKey, RMSequenceBean rmBean, SequenceEntry entry) throws SandeshaException, SandeshaStorageException, AxisFault {
        MessageContext referenceMessage;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: PollingManager::pollForSequence, rmBean: " + rmBean));
        }
        EndpointReference replyTo = rmBean.getReplyToEndpointReference();
        String wireSeqId = null;
        String wireAddress = null;
        if (anonUUID != null) {
            wireAddress = anonUUID;
        } else if (replyTo != null && SandeshaUtil.isWSRMAnonymous(replyTo.getAddress())) {
            wireAddress = replyTo.getAddress();
        } else {
            wireSeqId = rmBean.getSequenceID();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Debug: PollingManager::pollForSequence, wireAddress=" + wireAddress + " wireSeqId=" + wireSeqId));
        }
        if ((referenceMessage = this.storageManager.retrieveMessageContext(referenceMsgKey, this.context)) != null) {
            RMMsgContext referenceRMMessage = MsgInitializer.initializeMessage(referenceMessage);
            RMMsgContext makeConnectionRMMessage = RMMsgCreator.createMakeConnectionMessage(referenceRMMessage, rmBean, wireSeqId, wireAddress);
            makeConnectionRMMessage.getMessageContext().setServerSide(false);
            OperationContext ctx = makeConnectionRMMessage.getMessageContext().getOperationContext();
            ctx.setProperty("Sandesha2MakeConnectionEntry", (Object)entry);
            makeConnectionRMMessage.setProperty("TRANSPORT_IN", null);
            String makeConnectionMsgStoreKey = SandeshaUtil.getUUID();
            SenderBean makeConnectionSenderBean = new SenderBean();
            makeConnectionSenderBean.setInternalSequenceID(internalSeqId);
            makeConnectionSenderBean.setMessageContextRefKey(makeConnectionMsgStoreKey);
            makeConnectionSenderBean.setMessageID(makeConnectionRMMessage.getMessageId());
            makeConnectionSenderBean.setMessageType(11);
            makeConnectionSenderBean.setReSend(false);
            makeConnectionSenderBean.setSend(true);
            makeConnectionSenderBean.setSequenceID(rmBean.getSequenceID());
            EndpointReference to = makeConnectionRMMessage.getTo();
            if (to != null) {
                makeConnectionSenderBean.setToAddress(to.getAddress());
            }
            SenderBeanMgr senderBeanMgr = this.storageManager.getSenderBeanMgr();
            makeConnectionRMMessage.setProperty("Sandesha2QualifiedForSending", "false");
            SandeshaUtil.executeAndStore(makeConnectionRMMessage, makeConnectionMsgStoreKey, this.storageManager);
            senderBeanMgr.insert(makeConnectionSenderBean);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: PollingManager::pollForSequence");
        }
    }

    public synchronized void schedulePollingRequest(String sequenceId, boolean rmSource) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: PollingManager::shedulePollingRequest, " + sequenceId));
        }
        SequenceEntry entry = new SequenceEntry(sequenceId, rmSource);
        this.scheduledPollingRequests.add(entry);
        this.wakeThread();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: PollingManager::shedulePollingRequest");
        }
    }
}

