/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.msgprocessors.MsgProcessor;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.LoggingControl;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.workers.SandeshaThread;
import org.apache.sandesha2.workers.SenderWorker;
import org.apache.sandesha2.workers.WorkerLock;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.MakeConnection;
import org.apache.sandesha2.wsrm.MessagePending;

public class MakeConnectionProcessor
implements MsgProcessor {
    private static final Log log = LogFactory.getLog(MakeConnectionProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processInMessage(RMMsgContext rmMsgCtx, Transaction transaction) throws AxisFault {
        block33: {
            boolean bl;
            block32: {
                boolean bl2;
                block31: {
                    if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                        log.debug((Object)("Enter: MakeConnectionProcessor::processInMessage " + rmMsgCtx.getSOAPEnvelope().getBody()));
                    }
                    try {
                        boolean pending;
                        SenderBean senderBean;
                        StorageManager storageManager;
                        MakeConnection makeConnection;
                        block29: {
                            block30: {
                                Random random;
                                makeConnection = rmMsgCtx.getMakeConnection();
                                String address = makeConnection.getAddress();
                                Identifier identifier = makeConnection.getIdentifier();
                                if (address == null && identifier == null) {
                                    FaultManager.makeMissingSelectionFault(rmMsgCtx);
                                }
                                if (makeConnection.getUnexpectedElement() != null) {
                                    FaultManager.makeUnsupportedSelectionFault(rmMsgCtx, makeConnection.getUnexpectedElement());
                                }
                                ConfigurationContext configurationContext = rmMsgCtx.getConfigurationContext();
                                storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, (AxisDescription)configurationContext.getAxisConfiguration());
                                SecurityManager secManager = SandeshaUtil.getSecurityManager(configurationContext);
                                SecurityToken token = secManager.getSecurityToken(rmMsgCtx.getMessageContext());
                                ArrayList<RMSequenceBean> possibleBeans = new ArrayList<RMSequenceBean>();
                                int possibleBeanIndex = -10;
                                SenderBean findSenderBean = new SenderBean();
                                boolean secured = false;
                                if (token != null && identifier == null) {
                                    secured = true;
                                    if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                                        log.debug((Object)("token found " + token));
                                    }
                                    String data = secManager.getTokenRecoveryData(token);
                                    RMSBean finderRMS = new RMSBean();
                                    finderRMS.setSecurityTokenData(data);
                                    finderRMS.setToEPR(address);
                                    List<RMSBean> tempList2 = storageManager.getRMSBeanMgr().find(finderRMS);
                                    possibleBeans.addAll(tempList2);
                                    RMDBean finderRMD = new RMDBean();
                                    finderRMD.setSecurityTokenData(data);
                                    finderRMD.setToAddress(address);
                                    List<RMDBean> tempList = storageManager.getRMDBeanMgr().find(finderRMD);
                                    possibleBeans.addAll(tempList);
                                    int size = possibleBeans.size();
                                    if (size > 0) {
                                        random = new Random();
                                        possibleBeanIndex = random.nextInt(size);
                                        RMSequenceBean selectedSequence = (RMSequenceBean)possibleBeans.get(possibleBeanIndex);
                                        findSenderBean.setSequenceID(selectedSequence.getSequenceID());
                                        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                                            log.debug((Object)("sequence selected " + findSenderBean.getSequenceID()));
                                        }
                                    } else {
                                        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                                            log.debug((Object)"Exit: MakeConnectionProcessor::processInMessage : no RM sequence bean with security credentials");
                                        }
                                        boolean random2 = false;
                                        Object var25_27 = null;
                                        if (transaction == null) return random2;
                                        if (transaction.isActive()) {
                                            transaction.rollback();
                                        }
                                        return random2;
                                    }
                                    if (transaction != null && transaction.isActive()) {
                                        transaction.commit();
                                    }
                                    transaction = storageManager.getTransaction();
                                }
                                SenderBeanMgr senderBeanMgr = storageManager.getSenderBeanMgr();
                                findSenderBean.setSend(true);
                                findSenderBean.setTransportAvailable(false);
                                if (address != null) {
                                    findSenderBean.setToAddress(address);
                                }
                                if (identifier != null) {
                                    if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                                        log.debug((Object)("identifier set, this violates RSP " + identifier));
                                    }
                                    findSenderBean.setSequenceID(identifier.getIdentifier());
                                }
                                senderBean = null;
                                pending = false;
                                while (true) {
                                    findSenderBean.setTimeToSend(System.currentTimeMillis());
                                    List<SenderBean> collection = senderBeanMgr.find(findSenderBean);
                                    Iterator it = collection.iterator();
                                    while (it.hasNext()) {
                                        SenderBean bean = (SenderBean)it.next();
                                        if (bean.isReSend() || bean.getSentCount() <= 0) continue;
                                        it.remove();
                                    }
                                    int size = collection.size();
                                    int itemToPick = -1;
                                    pending = false;
                                    if (size > 0) {
                                        random = new Random();
                                        itemToPick = random.nextInt(size);
                                    }
                                    if (size > 1) {
                                        pending = true;
                                    }
                                    Iterator it2 = collection.iterator();
                                    senderBean = null;
                                    for (int item = 0; item < size; ++item) {
                                        senderBean = (SenderBean)it2.next();
                                        if (item == itemToPick) break;
                                    }
                                    if (senderBean != null) break block29;
                                    if (!secured) break block30;
                                    possibleBeans.remove(possibleBeanIndex);
                                    int possBeansSize = possibleBeans.size();
                                    if (possBeansSize <= 0) break;
                                    Random random3 = new Random();
                                    possibleBeanIndex = random3.nextInt(possBeansSize);
                                    RMSequenceBean selectedSequence = (RMSequenceBean)possibleBeans.get(possibleBeanIndex);
                                    findSenderBean.setSequenceID(selectedSequence.getSequenceID());
                                    if (!LoggingControl.isAnyTracingEnabled() || !log.isDebugEnabled()) continue;
                                    log.debug((Object)("sequence selected " + findSenderBean.getSequenceID()));
                                }
                                if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                                    log.debug((Object)"Exit: MakeConnectionProcessor::processInMessage, no matching message found");
                                }
                                bl2 = false;
                                break block31;
                            }
                            if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                                log.debug((Object)"Exit: MakeConnectionProcessor::processInMessage, no matching message found");
                            }
                            rmMsgCtx.getMessageContext().setProperty("FORCE_SC_ACCEPTED", (Object)"true");
                            bl = false;
                            break block32;
                        }
                        if (transaction != null && transaction.isActive()) {
                            transaction.commit();
                            transaction = storageManager.getTransaction();
                        }
                        MakeConnectionProcessor.replyToPoll(rmMsgCtx, senderBean, storageManager, pending, makeConnection.getNamespaceValue(), transaction);
                        break block33;
                    }
                    catch (Throwable throwable) {
                        Object var25_31 = null;
                        if (transaction != null && transaction.isActive()) {
                            transaction.rollback();
                        }
                        throw throwable;
                    }
                }
                Object var25_28 = null;
                if (transaction == null) return bl2;
                if (transaction.isActive()) {
                    transaction.rollback();
                }
                return bl2;
            }
            Object var25_29 = null;
            if (transaction == null) return bl;
            if (transaction.isActive()) {
                transaction.rollback();
            }
            return bl;
        }
        Object var25_30 = null;
        if (transaction != null && transaction.isActive()) {
            transaction.rollback();
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)"Exit: MakeConnectionProcessor::processInMessage");
        }
        return false;
    }

    public static void replyToPoll(RMMsgContext pollMessage, SenderBean matchingMessage, StorageManager storageManager, boolean pending, String makeConnectionNamespace, Transaction transaction) throws AxisFault {
        TransportOutDescription transportOut;
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)"Enter: MakeConnectionProcessor::replyToPoll");
        }
        if ((transportOut = pollMessage.getMessageContext().getTransportOut()) == null) {
            String message = SandeshaMessageHelper.getMessage("cantSendMakeConnectionNoTransportOut");
            if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new SandeshaException(message);
        }
        String messageStorageKey = matchingMessage.getMessageContextRefKey();
        MessageContext returnMessage = storageManager.retrieveMessageContext(messageStorageKey, pollMessage.getConfigurationContext());
        if (returnMessage == null) {
            String message = "Cannot find the message stored with the key:" + messageStorageKey;
            if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            return;
        }
        if (pending) {
            MakeConnectionProcessor.addMessagePendingHeader(returnMessage, makeConnectionNamespace);
        }
        boolean continueSending = true;
        RMMsgContext returnRMMsg = MsgInitializer.initializeMessage(returnMessage);
        if (returnRMMsg.getRMNamespaceValue() == null) {
            String sequenceID;
            if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                log.debug((Object)"Looking up rmNamespace from RMS bean");
            }
            if ((sequenceID = matchingMessage.getSequenceID()) != null) {
                RMSBean rmsBean = new RMSBean();
                rmsBean.setSequenceID(sequenceID);
                rmsBean = storageManager.getRMSBeanMgr().findUnique(rmsBean);
                if (rmsBean != null) {
                    returnRMMsg.setRMNamespaceValue(SpecSpecificConstants.getRMNamespaceValue(rmsBean.getRMVersion()));
                } else {
                    if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                        log.debug((Object)"Could not find RMS bean for polled msg");
                    }
                    continueSending = false;
                    storageManager.getSenderBeanMgr().delete(matchingMessage.getMessageID());
                }
            }
        }
        if (continueSending) {
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            SandeshaThread sender = storageManager.getSender();
            WorkerLock lock = sender.getWorkerLock();
            String workId = matchingMessage.getMessageID();
            SenderWorker worker = new SenderWorker(pollMessage.getConfigurationContext(), matchingMessage, pollMessage.getRMSpecVersion());
            worker.setLock(lock);
            worker.setWorkId(workId);
            while (!lock.addWork(workId, worker)) {
                try {
                    lock.awaitRemoval(workId);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            MakeConnectionProcessor.setTransportProperties(returnMessage, pollMessage);
            AxisOperation operation = SpecSpecificConstants.getWSRMOperation(15, pollMessage.getRMSpecVersion(), pollMessage.getMessageContext().getAxisService());
            OperationContext context = new OperationContext(operation, pollMessage.getMessageContext().getServiceContext());
            context.addMessageContext(returnMessage);
            returnMessage.setServiceContext(null);
            returnMessage.setOperationContext(context);
            returnMessage.setProperty("MakeConnectionResponse", (Object)Boolean.TRUE);
            returnMessage.setProperty("RequestResponseTransportControl", pollMessage.getProperty("RequestResponseTransportControl"));
            worker.setMessage(returnRMMsg);
            worker.run();
            TransportUtils.setResponseWritten((MessageContext)pollMessage.getMessageContext(), (boolean)true);
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)"Exit: MakeConnectionProcessor::replyToPoll");
        }
    }

    private static void addMessagePendingHeader(MessageContext returnMessage, String namespace) {
        MessagePending messagePending = new MessagePending();
        messagePending.setPending(true);
        if (returnMessage.getEnvelope().getHeader() == null) {
            int SOAPVersion2 = 1;
            if (!returnMessage.isSOAP11()) {
                SOAPVersion2 = 2;
            }
            SOAPAbstractFactory.getSOAPFactory(SOAPVersion2).createSOAPHeader(returnMessage.getEnvelope());
        }
        messagePending.toHeader(returnMessage.getEnvelope().getHeader());
    }

    public boolean processOutMessage(RMMsgContext rmMsgCtx, Transaction transaction) {
        return false;
    }

    private static void setTransportProperties(MessageContext returnMessage, RMMsgContext makeConnectionMessage) {
        returnMessage.setProperty("TRANSPORT_OUT", makeConnectionMessage.getProperty("TRANSPORT_OUT"));
        returnMessage.setProperty("OutTransportInfo", makeConnectionMessage.getProperty("OutTransportInfo"));
        Object contentType = makeConnectionMessage.getProperty("ContentType");
        returnMessage.setProperty("ContentType", contentType);
        returnMessage.setTransportOut(makeConnectionMessage.getMessageContext().getTransportOut());
    }
}

