/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.userdefined;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.PreparedStatement;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.generate.Row;
import org.apache.cassandra.stress.operations.PartitionOperation;
import org.apache.cassandra.stress.report.Timer;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;

public abstract class SchemaStatement
extends PartitionOperation {
    final PreparedStatement statement;
    final ConsistencyLevel cl;
    final int[] argumentIndex;
    final Object[] bindBuffer;
    final ColumnDefinitions definitions;

    public SchemaStatement(Timer timer, StressSettings settings, PartitionOperation.DataSpec spec, PreparedStatement statement, List<String> bindNames, ConsistencyLevel cl) {
        super(timer, settings, spec);
        this.statement = statement;
        this.cl = cl;
        this.argumentIndex = new int[bindNames.size()];
        this.bindBuffer = new Object[this.argumentIndex.length];
        this.definitions = statement != null ? statement.getVariables() : null;
        int i = 0;
        for (String name : bindNames) {
            this.argumentIndex[i++] = spec.partitionGenerator.indexOf(name);
        }
        if (statement != null) {
            if (cl.isSerialConsistency()) {
                statement.setSerialConsistencyLevel(JavaDriverClient.from(cl));
            } else {
                statement.setConsistencyLevel(JavaDriverClient.from(cl));
            }
        }
    }

    BoundStatement bindRow(Row row) {
        assert (this.statement != null);
        for (int i = 0; i < this.argumentIndex.length; ++i) {
            Object value = row.get(this.argumentIndex[i]);
            if (this.definitions.getType(i).getName().equals((Object)DataType.date().getName())) {
                value = LocalDate.fromDaysSinceEpoch((int)((Integer)value));
            }
            this.bindBuffer[i] = value;
            if (this.bindBuffer[i] != null || this.spec.partitionGenerator.permitNulls(this.argumentIndex[i])) continue;
            throw new IllegalStateException();
        }
        return this.statement.bind(this.bindBuffer);
    }

    List<ByteBuffer> rowArgs(Row row) {
        ArrayList<ByteBuffer> args = new ArrayList<ByteBuffer>();
        for (int i : this.argumentIndex) {
            args.add(this.spec.partitionGenerator.convert(i, row.get(i)));
        }
        return args;
    }

    abstract class Runner
    implements Operation.RunOp {
        int partitionCount;
        int rowCount;

        Runner() {
        }

        @Override
        public int partitionCount() {
            return this.partitionCount;
        }

        @Override
        public int rowCount() {
            return this.rowCount;
        }
    }

    public static enum ArgSelect {
        MULTIROW,
        SAMEROW;

    }
}

