/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.exceptions;

import javax.annotation.Nullable;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.streaming.PreviewKind;

public class RepairException
extends Exception {
    private final boolean shouldLogWarn;

    private RepairException(@Nullable RepairJobDesc desc, PreviewKind previewKind, String message, boolean shouldLogWarn) {
        this((desc == null ? "" : desc.toString(previewKind != null ? previewKind : PreviewKind.NONE)) + " " + message, shouldLogWarn);
    }

    private RepairException(String msg, boolean shouldLogWarn) {
        super(msg);
        this.shouldLogWarn = shouldLogWarn;
    }

    public static RepairException error(@Nullable RepairJobDesc desc, PreviewKind previewKind, String message) {
        return new RepairException(desc, previewKind, message, false);
    }

    public static RepairException warn(@Nullable RepairJobDesc desc, PreviewKind previewKind, String message) {
        return new RepairException(desc, previewKind, message, true);
    }

    public static RepairException warn(String message) {
        return new RepairException(message, true);
    }

    public static boolean shouldWarn(Throwable throwable) {
        return throwable instanceof RepairException && ((RepairException)throwable).shouldLogWarn;
    }
}

