/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.vector;

import com.google.common.primitives.Ints;
import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.disk.ReaderSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.Rebufferer;

public class RandomAccessReaderAdapter
extends org.apache.cassandra.io.util.RandomAccessReader
implements RandomAccessReader {
    static ReaderSupplier createSupplier(FileHandle fileHandle) {
        return () -> new RandomAccessReaderAdapter(fileHandle);
    }

    RandomAccessReaderAdapter(FileHandle fileHandle) {
        super(fileHandle.instantiateRebufferer(null));
    }

    public void readFully(float[] dest) throws IOException {
        ByteBuffer bb;
        FloatBuffer floatBuffer;
        Rebufferer.BufferHolder bh = this.bufferHolder;
        long position = this.getPosition();
        if (bh.offset() == 0L && position % 4L == 0L) {
            floatBuffer = bh.floatBuffer();
            floatBuffer.position(Ints.checkedCast((long)(position / 4L)));
        } else {
            bb = bh.buffer();
            bb.position(Ints.checkedCast((long)(position - bh.offset())));
            floatBuffer = bb.asFloatBuffer();
        }
        if (dest.length > floatBuffer.remaining()) {
            bb = ByteBuffer.allocate(4 * dest.length);
            this.readFully(bb);
            floatBuffer = bb.asFloatBuffer();
        }
        floatBuffer.get(dest);
        this.seek(position + 4L * (long)dest.length);
    }

    public void read(int[] dest, int offset, int count) throws IOException {
        ByteBuffer bb;
        IntBuffer intBuffer;
        if (count == 0) {
            return;
        }
        Rebufferer.BufferHolder bh = this.bufferHolder;
        long position = this.getPosition();
        if (bh.offset() == 0L && position % 4L == 0L) {
            intBuffer = bh.intBuffer();
            intBuffer.position(Ints.checkedCast((long)(position / 4L)));
        } else {
            bb = bh.buffer();
            bb.position(Ints.checkedCast((long)(position - bh.offset())));
            intBuffer = bb.asIntBuffer();
        }
        if (count > intBuffer.remaining()) {
            bb = ByteBuffer.allocate(4 * count);
            this.readFully(bb);
            intBuffer = bb.asIntBuffer();
        }
        intBuffer.get(dest, offset, count);
        this.seek(position + 4L * (long)count);
    }
}

