/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.function.LongConsumer;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.BufferedDataOutputStreamPlus;
import org.apache.cassandra.io.util.DataPosition;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.PageAware;
import org.apache.cassandra.io.util.SequentialWriterOption;
import org.apache.cassandra.utils.SyncUtil;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.Transactional;

public class SequentialWriter
extends BufferedDataOutputStreamPlus
implements Transactional {
    private final String filePath;
    private final File file;
    protected long bufferOffset;
    protected final FileChannel fchannel;
    private final boolean strictFlushing;
    protected final SequentialWriterOption option;
    private int bytesSinceTrickleFsync = 0;
    protected long lastFlushOffset;
    protected LongConsumer runPostFlush;
    private final TransactionalProxy txnProxy = this.txnProxy();

    private static FileChannel openChannel(File file) {
        try {
            if (file.exists()) {
                return FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
            }
            FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
            try {
                SyncUtil.trySyncDir(file.parent());
            }
            catch (Throwable t) {
                try {
                    channel.close();
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
            }
            return channel;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SequentialWriter(File file) {
        this(file, SequentialWriterOption.DEFAULT);
    }

    public SequentialWriter(File file, SequentialWriterOption option) {
        this(file, option, true);
    }

    public SequentialWriter(File file, SequentialWriterOption option, boolean strictFlushing) {
        this(file, option.allocateBuffer(), option, strictFlushing);
    }

    protected SequentialWriter(File file, ByteBuffer buffer, SequentialWriterOption option, boolean strictFlushing) {
        super((WritableByteChannel)SequentialWriter.openChannel(file), buffer);
        this.strictFlushing = strictFlushing;
        this.fchannel = (FileChannel)this.channel;
        this.file = file;
        this.filePath = file.absolutePath();
        this.option = option;
    }

    public void skipBytes(long numBytes) throws IOException {
        this.flush();
        this.fchannel.position(this.fchannel.position() + numBytes);
        this.bufferOffset = this.fchannel.position();
    }

    public void sync() {
        this.syncInternal();
    }

    protected void syncDataOnlyInternal() {
        try {
            SyncUtil.force(this.fchannel, false);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    protected void syncInternal() {
        this.doFlush(0);
        this.syncDataOnlyInternal();
    }

    @Override
    protected void doFlush(int count) {
        this.flushData();
        if (this.option.trickleFsync()) {
            this.bytesSinceTrickleFsync += this.buffer.position();
            if (this.bytesSinceTrickleFsync >= this.option.trickleFsyncByteInterval()) {
                this.syncDataOnlyInternal();
                this.bytesSinceTrickleFsync = 0;
            }
        }
        this.resetBuffer();
    }

    public void setPostFlushListener(LongConsumer runPostFlush) {
        assert (this.runPostFlush == null);
        this.runPostFlush = runPostFlush;
    }

    protected void flushData() {
        try {
            this.buffer.flip();
            this.channel.write(this.buffer);
            this.lastFlushOffset += (long)this.buffer.position();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
        if (this.runPostFlush != null) {
            this.runPostFlush.accept(this.getLastFlushOffset());
        }
    }

    @Override
    public boolean hasPosition() {
        return true;
    }

    @Override
    public long position() {
        return this.current();
    }

    @Override
    public int maxBytesInPage() {
        return 4096;
    }

    @Override
    public void padToPageBoundary() throws IOException {
        PageAware.pad(this);
    }

    @Override
    public int bytesLeftInPage() {
        return PageAware.bytesLeftInPage(this.position());
    }

    @Override
    public long paddedPosition() {
        return PageAware.padded(this.position());
    }

    public long getOnDiskFilePointer() {
        return this.position();
    }

    public long getEstimatedOnDiskBytesWritten() {
        return this.getOnDiskFilePointer();
    }

    public long length() {
        try {
            return Math.max(this.current(), this.fchannel.size());
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
    }

    public String getPath() {
        return this.filePath;
    }

    public File getFile() {
        return this.file;
    }

    protected void resetBuffer() {
        this.bufferOffset = this.current();
        this.buffer.clear();
    }

    protected long current() {
        return this.bufferOffset + (long)(this.buffer == null ? 0 : this.buffer.position());
    }

    public DataPosition mark() {
        return new BufferedFileWriterMark(this.current());
    }

    public void resetAndTruncate(DataPosition mark) {
        long truncateTarget;
        assert (mark instanceof BufferedFileWriterMark);
        long previous = this.current();
        if (previous - (truncateTarget = ((BufferedFileWriterMark)mark).pointer) <= (long)this.buffer.position()) {
            this.buffer.position(this.buffer.position() - (int)(previous - truncateTarget));
            return;
        }
        this.syncInternal();
        this.truncate(truncateTarget);
        try {
            this.fchannel.position(truncateTarget);
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
        this.bufferOffset = truncateTarget;
        this.resetBuffer();
    }

    public long getLastFlushOffset() {
        return this.lastFlushOffset;
    }

    public void truncate(long toSize) {
        try {
            this.fchannel.truncate(toSize);
            this.lastFlushOffset = toSize;
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public final void prepareToCommit() {
        this.txnProxy.prepareToCommit();
    }

    @Override
    public final Throwable commit(Throwable accumulate) {
        return this.txnProxy.commit(accumulate);
    }

    @Override
    public final Throwable abort(Throwable accumulate) {
        return this.txnProxy.abort(accumulate);
    }

    @Override
    public final void close() {
        if (this.option.finishOnClose()) {
            this.txnProxy.finish();
        } else {
            this.txnProxy.close();
        }
    }

    public int writeDirectlyToChannel(ByteBuffer buf) throws IOException {
        if (this.strictFlushing) {
            throw new UnsupportedOperationException();
        }
        this.flush();
        return this.channel.write(buf);
    }

    public final void finish() {
        this.txnProxy.finish();
    }

    protected TransactionalProxy txnProxy() {
        return new TransactionalProxy();
    }

    protected static class BufferedFileWriterMark
    implements DataPosition {
        final long pointer;

        public BufferedFileWriterMark(long pointer) {
            this.pointer = pointer;
        }
    }

    protected class TransactionalProxy
    extends Transactional.AbstractTransactional {
        protected TransactionalProxy() {
        }

        @Override
        protected Throwable doPreCleanup(Throwable accumulate) {
            try {
                SequentialWriter.this.channel.close();
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
            if (SequentialWriter.this.buffer != null) {
                try {
                    FileUtils.clean(SequentialWriter.this.buffer);
                }
                catch (Throwable t) {
                    accumulate = Throwables.merge(accumulate, t);
                }
                SequentialWriter.this.buffer = null;
            }
            return accumulate;
        }

        @Override
        protected void doPrepare() {
            SequentialWriter.this.syncInternal();
        }

        @Override
        protected Throwable doCommit(Throwable accumulate) {
            return accumulate;
        }

        @Override
        protected Throwable doAbort(Throwable accumulate) {
            return accumulate;
        }
    }
}

