/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EvpKeyType;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.MiscInterfaces;
import com.amazon.corretto.crypto.provider.NativeResource;
import com.amazon.corretto.crypto.provider.RuntimeCryptoException;
import com.amazon.corretto.crypto.provider.Utils;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import javax.security.auth.Destroyable;

abstract class EvpKey
implements Key,
Destroyable {
    private static final long serialVersionUID = 1L;
    protected final InternalKey internalKey;
    protected final EvpKeyType type;
    protected final boolean isPublicKey;
    protected boolean ephemeral = false;
    protected volatile byte[] encoded;
    protected volatile Integer cachedHashCode;

    private static native void releaseKey(long var0);

    private static native byte[] encodePublicKey(long var0);

    private static native byte[] encodePrivateKey(long var0);

    protected static native byte[] getDerEncodedParams(long var0);

    EvpKey(InternalKey internalKey, EvpKeyType evpKeyType, boolean bl) {
        Loader.checkNativeLibraryAvailability();
        this.internalKey = internalKey;
        this.type = evpKeyType;
        this.isPublicKey = bl;
    }

    boolean isEphemeral() {
        return this.ephemeral;
    }

    void setEphemeral(boolean bl) {
        this.ephemeral = bl;
    }

    void releaseEphemeral() {
        if (this.ephemeral) {
            this.destroy();
        }
    }

    <T, X extends Throwable> T use(MiscInterfaces.ThrowingLongFunction<T, X> throwingLongFunction) throws X {
        return this.internalKey.use(throwingLongFunction);
    }

    <X extends Throwable> void useVoid(MiscInterfaces.ThrowingLongConsumer<X> throwingLongConsumer) throws X {
        this.internalKey.useVoid(throwingLongConsumer);
    }

    @Override
    public String getAlgorithm() {
        return this.type.jceName;
    }

    @Override
    public String getFormat() {
        return this.isPublicKey ? "X.509" : "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        byte[] byArray = this.internalGetEncoded();
        return byArray != null ? (byte[])byArray.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] internalGetEncoded() {
        byte[] byArray = this.encoded;
        if (byArray == null) {
            EvpKey evpKey = this;
            synchronized (evpKey) {
                byArray = this.encoded;
                if (byArray == null) {
                    this.encoded = byArray = this.isPublicKey ? this.use(EvpKey::encodePublicKey) : this.use(EvpKey::encodePrivateKey);
                }
            }
        }
        return byArray;
    }

    protected <X extends Throwable> BigInteger nativeBN(MiscInterfaces.ThrowingLongFunction<byte[], X> throwingLongFunction) throws X {
        byte[] byArray = this.use(throwingLongFunction::apply);
        return new BigInteger(1, byArray);
    }

    protected <T extends AlgorithmParameterSpec> T nativeParams(Class<T> clazz) {
        byte[] byArray = this.use(EvpKey::getDerEncodedParams);
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.type.jceName);
            algorithmParameters.init(byArray);
            return algorithmParameters.getParameterSpec(clazz);
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new RuntimeCryptoException("Unable to deserialize parameters: " + Base64.getEncoder().encodeToString(this.encoded), exception);
        }
    }

    protected synchronized void destroyJavaState() {
    }

    public boolean equals(Object object) {
        byte[] byArray;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Key)) {
            return false;
        }
        Key key = (Key)object;
        if (!this.getAlgorithm().equalsIgnoreCase(key.getAlgorithm())) {
            return false;
        }
        if (object.getClass().equals(this.getClass())) {
            EvpKey evpKey = (EvpKey)object;
            if (this.internalKey.equals(evpKey.internalKey)) {
                return true;
            }
            byArray = evpKey.internalGetEncoded();
        } else {
            byArray = key.getEncoded();
        }
        return MessageDigest.isEqual(this.internalGetEncoded(), byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Integer n = this.cachedHashCode;
        if (n == null) {
            EvpKey evpKey = this;
            synchronized (evpKey) {
                n = this.cachedHashCode;
                if (n != null) {
                    return this.cachedHashCode;
                }
                byte[] byArray = this.internalGetEncoded();
                int n2 = 0;
                if (this.isPublicKey) {
                    n2 = byArray.length;
                    for (byte by : byArray) {
                        n2 += (by & 0xFF) * 37;
                    }
                } else if (Utils.getJavaVersion() >= 17) {
                    n2 = Arrays.hashCode(byArray);
                } else {
                    for (int i = 0; i < byArray.length; ++i) {
                        n2 += byArray[i] * i;
                    }
                }
                this.cachedHashCode = n = Integer.valueOf(n2);
            }
        }
        return n;
    }

    @Override
    public boolean isDestroyed() {
        return this.internalKey.isReleased();
    }

    @Override
    public synchronized void destroy() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("Already destroyed");
        }
        this.internalKey.release();
        this.destroyJavaState();
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializedKey(this.type, this.isPublicKey, this.internalGetEncoded());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException("EvpKey");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException("EvpKey");
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new NotSerializableException("EvpKey");
    }

    private static class SerializedKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final EvpKeyType type;
        private final boolean isPublicKey;
        private final byte[] encoded;

        public SerializedKey(EvpKeyType evpKeyType, boolean bl, byte[] byArray) {
            this.type = evpKeyType;
            this.isPublicKey = bl;
            this.encoded = byArray;
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                KeyFactory keyFactory = AmazonCorrettoCryptoProvider.INSTANCE.getKeyFactory(this.type);
                if (this.isPublicKey) {
                    return keyFactory.generatePublic(new X509EncodedKeySpec(this.encoded));
                }
                return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(this.encoded));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidObjectException(invalidKeySpecException.getMessage());
            }
        }
    }

    protected static interface CanDerivePublicKey<T extends EvpKey> {
        public T getPublicKey();
    }

    protected static class InternalKey
    extends NativeResource {
        InternalKey(long l2) {
            super(l2, l -> EvpKey.releaseKey(l), true);
        }
    }
}

