/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.fqltool.commands;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.apache.cassandra.fqltool.FQLQuery;
import org.apache.cassandra.fqltool.FQLQueryIterator;
import org.apache.cassandra.fqltool.QueryReplayer;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.MergeIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="replay", description="Replay full query logs")
public class Replay
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Replay.class);
    @Arguments(usage="<path1> [<path2>...<pathN>]", description="Paths containing the full query logs to replay.", required=true)
    private List<String> arguments = new ArrayList<String>();
    @Option(title="target", name={"--target"}, description="Hosts to replay the logs to, can be repeated to replay to more hosts.", required=true)
    private List<String> targetHosts;
    @Option(title="results", name={"--results"}, description="Where to store the results of the queries, this should be a directory. Leave this option out to avoid storing results.")
    private String resultPath;
    @Option(title="keyspace", name={"--keyspace"}, description="Only replay queries against this keyspace and queries without keyspace set.")
    private String keyspace;
    @Option(title="store_queries", name={"--store-queries"}, description="Path to store the queries executed. Stores queries in the same order as the result sets are in the result files. Requires --results")
    private String queryStorePath;
    @Option(title="replay_ddl_statements", name={"--replay-ddl-statements"}, description="If specified, replays DDL statements as well, they are excluded from replaying by default.")
    private boolean replayDDLStatements;

    @Override
    public void run() {
        try {
            List<File> resultPaths = null;
            if (this.resultPath != null) {
                File basePath = new File(this.resultPath);
                if (!basePath.exists() || !basePath.isDirectory()) {
                    System.err.println("The results path (" + basePath + ") should be an existing directory");
                    System.exit(1);
                }
                resultPaths = this.targetHosts.stream().map(target -> new File(basePath, (String)target)).collect(Collectors.toList());
                resultPaths.forEach(File::mkdir);
            }
            if (this.targetHosts.size() < 1) {
                System.err.println("You need to state at least one --target host to replay the query against");
                System.exit(1);
            }
            Replay.replay(this.keyspace, this.arguments, this.targetHosts, resultPaths, this.queryStorePath, this.replayDDLStatements);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void replay(String keyspace, List<String> arguments, List<String> targetHosts, List<File> resultPaths, String queryStorePath, boolean replayDDLStatements) {
        int readAhead = 200;
        List<ChronicleQueue> readQueues = null;
        List<FQLQueryIterator> iterators = null;
        ArrayList<Predicate<FQLQuery>> filters = new ArrayList<Predicate<FQLQuery>>();
        if (keyspace != null) {
            filters.add(fqlQuery -> fqlQuery.keyspace() == null || fqlQuery.keyspace().equals(keyspace));
        }
        if (!replayDDLStatements) {
            filters.add(fqlQuery -> {
                boolean notDDLStatement;
                boolean bl = notDDLStatement = !fqlQuery.isDDLStatement();
                if (!notDDLStatement) {
                    logger.info("Excluding DDL statement from replaying: {}", (Object)((FQLQuery.Single)fqlQuery).query);
                }
                return notDDLStatement;
            });
        }
        try {
            readQueues = arguments.stream().map(s -> SingleChronicleQueueBuilder.single((String)s).readOnly(true).build()).collect(Collectors.toList());
            iterators = readQueues.stream().map(ChronicleQueue::createTailer).map(tailer -> new FQLQueryIterator((ExcerptTailer)tailer, readAhead)).collect(Collectors.toList());
            try (MergeIterator iter = MergeIterator.get(iterators, FQLQuery::compareTo, (MergeIterator.Reducer)new Reducer());
                 QueryReplayer replayer = new QueryReplayer((Iterator<List<FQLQuery>>)iter, targetHosts, resultPaths, filters, queryStorePath);){
                replayer.replay();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (iterators != null) {
                iterators.forEach(AbstractIterator::close);
            }
            if (readQueues != null) {
                readQueues.forEach(Closeable::close);
            }
        }
    }

    @VisibleForTesting
    public static class Reducer
    extends MergeIterator.Reducer<FQLQuery, List<FQLQuery>> {
        List<FQLQuery> queries = new ArrayList<FQLQuery>();

        public void reduce(int idx, FQLQuery current) {
            this.queries.add(current);
        }

        protected List<FQLQuery> getReduced() {
            return this.queries;
        }

        protected void onKeyChange() {
            this.queries.clear();
        }
    }
}

