/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.array;

import java.util.Iterator;
import org.psjava.ds.array.Array;
import org.psjava.ds.array.ArrayIterator;
import org.psjava.util.IterableToString;

public class MergedArray {
    public static <T> Array<T> wrap(final Array<T> left, final Array<T> right) {
        return new Array<T>(){

            @Override
            public T get(int index) {
                if (index < left.size()) {
                    return left.get(index);
                }
                return right.get(index - left.size());
            }

            @Override
            public int size() {
                return left.size() + right.size();
            }

            @Override
            public final boolean isEmpty() {
                return this.size() == 0;
            }

            @Override
            public final Iterator<T> iterator() {
                return ArrayIterator.create(this);
            }

            public final String toString() {
                return IterableToString.toString(this);
            }
        };
    }

    private MergedArray() {
    }
}

