/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.bridge.type.InternalDuration;
import org.apache.spark.unsafe.types.CalendarInterval;

public final class SparkTypeUtils {
    public static final Comparator<CalendarInterval> CALENDAR_INTERVAL_COMPARATOR = Comparator.comparingInt(interval -> interval.months).thenComparingInt(interval -> interval.days).thenComparingLong(interval -> interval.microseconds);

    private SparkTypeUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static CalendarInterval convertDuration(InternalDuration duration) {
        return new CalendarInterval(duration.months, duration.days, TimeUnit.NANOSECONDS.toMicros(duration.nanoseconds));
    }

    public static InternalDuration convertDuration(CalendarInterval interval) {
        return new InternalDuration(interval.months, interval.days, TimeUnit.MICROSECONDS.toNanos(interval.microseconds));
    }
}

