/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.reader.common;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.jetbrains.annotations.NotNull;

public class RawInputStream
extends InputStream {
    protected final DataInputStream source;
    protected final byte[] buffer;
    protected long bufferOffset;
    protected long current = 0L;
    protected int validBufferBytes = 0;
    private boolean endOfStream = false;
    protected final Stats stats;
    private boolean bufferInit = false;

    public RawInputStream(DataInputStream source, byte[] buffer, Stats stats) {
        this.source = source;
        this.buffer = buffer;
        this.stats = stats;
        this.stats.openedDataInputStream();
    }

    public boolean isEOF() {
        return this.endOfStream && this.finishedReadingBuffer();
    }

    private int bufferCursor() {
        return (int)(this.current - this.bufferOffset);
    }

    protected boolean finishedReadingBuffer() {
        return this.current >= this.bufferOffset + (long)this.validBufferBytes;
    }

    protected void maybeReBuffer() throws IOException {
        if (this.finishedReadingBuffer() || this.validBufferBytes < 0) {
            this.reBuffer();
        }
    }

    protected void reBuffer() throws IOException {
        if (this.endOfStream) {
            throw new RuntimeException("Shouldn't be reading from a known EOF stream");
        }
        if (this.bufferInit) {
            this.bufferOffset += (long)this.buffer.length;
        } else {
            this.bufferInit = true;
        }
        this.validBufferBytes = ByteBufferUtils.readFully((InputStream)this.source, (byte[])this.buffer, (int)this.buffer.length);
        this.stats.readBytes(this.validBufferBytes);
        if (this.validBufferBytes < this.buffer.length) {
            this.endOfStream = true;
        }
    }

    public long position() {
        return this.current;
    }

    protected long maybeStandardSkip(long count) throws IOException {
        if (count <= 0L) {
            return 0L;
        }
        if (count <= (long)this.remainingBytes()) {
            return this.standardSkip(count);
        }
        return -1L;
    }

    protected long skipBuffered() throws IOException {
        return this.standardSkip(this.remainingBytes());
    }

    public long standardSkip(long count) throws IOException {
        long actual = super.skip(count);
        this.stats.skippedBytes(actual);
        return actual;
    }

    @Override
    public long skip(long count) throws IOException {
        long skipped = this.maybeStandardSkip(count);
        if (skipped >= 0L) {
            return skipped;
        }
        long remaining = count - this.skipBuffered();
        skipped = this.source.skip(remaining);
        if (skipped > 0L) {
            remaining -= skipped;
            this.current += skipped;
            this.bufferOffset = this.current;
            this.validBufferBytes = -1;
            this.bufferInit = false;
        }
        long total = count - remaining;
        this.stats.skippedBytes(total);
        return total;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null) {
            throw new IOException();
        }
        if (this.isEOF()) {
            return -1;
        }
        this.maybeReBuffer();
        assert (this.bufferOffset <= this.current && this.current < this.bufferOffset + (long)this.validBufferBytes);
        return this.buffer[(int)(this.current++ - this.bufferOffset)] & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] buff, int offset, int length) throws IOException {
        if (this.buffer == null) {
            throw new IOException();
        }
        if (length == 0) {
            return 0;
        }
        if (this.isEOF()) {
            return -1;
        }
        this.maybeReBuffer();
        assert (this.bufferOffset <= this.current && this.current < this.bufferOffset + (long)this.validBufferBytes) : String.format("Current offset %d, buffer offset %d, buffer limit %d", this.current, this.bufferOffset, this.validBufferBytes);
        int toCopy = Math.min(length, this.remainingBytes());
        System.arraycopy(this.buffer, this.bufferCursor(), buff, offset, toCopy);
        this.current += (long)toCopy;
        return toCopy;
    }

    protected int remainingBytes() {
        return this.validBufferBytes - this.bufferCursor();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
        this.stats.closedDataInputStream();
    }
}

