/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.client;

import java.util.Objects;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;

public class SidecarInstanceImpl
implements SidecarInstance {
    protected int port;
    protected String hostname;

    public SidecarInstanceImpl(String hostname, int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException(String.format("Invalid port number for the Sidecar service: %d", port));
        }
        this.port = port;
        this.hostname = Objects.requireNonNull(hostname, "The Sidecar hostname must be non-null");
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public String hostname() {
        return this.hostname;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SidecarInstanceImpl that = (SidecarInstanceImpl)o;
        return this.port == that.port && Objects.equals(this.hostname, that.hostname);
    }

    public int hashCode() {
        return Objects.hash(this.port, this.hostname);
    }

    public String toString() {
        return "SidecarInstanceImpl{port=" + this.port + ", hostname='" + this.hostname + "'}";
    }
}

