/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import o.a.c.sidecar.client.shaded.client.HttpClient;
import o.a.c.sidecar.client.shaded.client.HttpClientConfig;
import o.a.c.sidecar.client.shaded.client.HttpResponse;
import o.a.c.sidecar.client.shaded.client.HttpResponseImpl;
import o.a.c.sidecar.client.shaded.client.RequestContext;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.client.StreamConsumer;
import o.a.c.sidecar.client.shaded.client.StreamConsumerWriteStream;
import o.a.c.sidecar.client.shaded.common.request.Request;
import o.a.c.sidecar.client.shaded.common.request.UploadableRequest;
import o.a.c.sidecar.client.shaded.common.utils.StringUtils;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import o.a.c.sidecar.client.shaded.io.vertx.core.Future;
import o.a.c.sidecar.client.shaded.io.vertx.core.MultiMap;
import o.a.c.sidecar.client.shaded.io.vertx.core.Promise;
import o.a.c.sidecar.client.shaded.io.vertx.core.Vertx;
import o.a.c.sidecar.client.shaded.io.vertx.core.buffer.Buffer;
import o.a.c.sidecar.client.shaded.io.vertx.core.file.AsyncFile;
import o.a.c.sidecar.client.shaded.io.vertx.core.file.FileSystem;
import o.a.c.sidecar.client.shaded.io.vertx.core.file.OpenOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.HttpMethod;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.KeyStoreOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.OpenSSLEngineOptions;
import o.a.c.sidecar.client.shaded.io.vertx.ext.web.client.HttpRequest;
import o.a.c.sidecar.client.shaded.io.vertx.ext.web.client.WebClient;
import o.a.c.sidecar.client.shaded.io.vertx.ext.web.client.WebClientOptions;
import o.a.c.sidecar.client.shaded.io.vertx.ext.web.client.predicate.ResponsePredicateResult;
import o.a.c.sidecar.client.shaded.io.vertx.ext.web.codec.BodyCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxHttpClient
implements HttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxHttpClient.class);
    protected final Vertx vertx;
    protected final WebClient webClient;
    protected final HttpClientConfig config;

    public VertxHttpClient(Vertx vertx, HttpClientConfig config) {
        WebClientOptions options = new WebClientOptions().setMaxPoolSize(config.maxPoolSize()).setIdleTimeout(config.idleTimeoutMillis()).setIdleTimeoutUnit(TimeUnit.MILLISECONDS).setMaxChunkSize(config.maxChunkSize()).setReceiveBufferSize(config.receiveBufferSize()).setConnectTimeout((int)config.timeoutMillis()).setUserAgent(config.userAgent());
        options = VertxHttpClient.applySSLOptions(options, config);
        this.vertx = vertx;
        this.webClient = WebClient.create(vertx, options);
        this.config = config;
    }

    public VertxHttpClient(Vertx vertx, WebClient webClient, HttpClientConfig config) {
        this.vertx = vertx;
        this.webClient = webClient;
        this.config = config;
    }

    Vertx vertx() {
        return this.vertx;
    }

    @Override
    public HttpClientConfig config() {
        return this.config;
    }

    @Override
    public CompletableFuture<HttpResponse> execute(SidecarInstance sidecarInstance, RequestContext context) {
        if (context.request() instanceof UploadableRequest) {
            HttpRequest<Buffer> vertxRequest = this.vertxRequest(sidecarInstance, context);
            UploadableRequest uploadableRequest = (UploadableRequest)((Object)context.request());
            LOGGER.debug("Uploading file={}, for request={}, instance={}", new Object[]{uploadableRequest.filename(), context.request(), sidecarInstance});
            return this.executeUploadFileInternal(sidecarInstance, vertxRequest, uploadableRequest.filename());
        }
        LOGGER.debug("Executing request={}, on instance={}", (Object)context.request(), (Object)sidecarInstance);
        return this.executeInternal(sidecarInstance, context);
    }

    protected CompletableFuture<HttpResponse> executeInternal(SidecarInstance sidecarInstance, RequestContext context) {
        Future<HttpRequest> future = Future.future(promise -> promise.complete(this.vertxRequest(sidecarInstance, context).ssl(this.config.ssl()).timeout(this.config.timeoutMillis())));
        return future.compose(vertxRequest -> {
            Request request = context.request();
            if (request.requestBody() != null) {
                return vertxRequest.sendJson(request.requestBody());
            }
            return vertxRequest.send();
        }).map(response -> {
            byte[] raw = response.body() != null ? ((Buffer)response.body()).getBytes() : null;
            return new HttpResponseImpl(response.statusCode(), response.statusMessage(), raw, this.mapHeaders(response.headers()), sidecarInstance);
        }).toCompletionStage().toCompletableFuture();
    }

    protected CompletableFuture<HttpResponse> executeUploadFileInternal(SidecarInstance sidecarInstance, HttpRequest<Buffer> vertxRequest, String filename) {
        Promise promise = Promise.promise();
        this.openFileForRead(this.vertx.fileSystem(), filename).compose(pair -> vertxRequest.ssl(this.config.ssl()).putHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(pair.getKey())).sendStream(((AsyncFile)pair.getValue()).setReadBufferSize(this.config.sendReadBufferSize()))).onFailure(promise::fail).onSuccess(response -> {
            byte[] raw = response.body() != null ? ((Buffer)response.body()).getBytes() : null;
            promise.complete(new HttpResponseImpl(response.statusCode(), response.statusMessage(), raw, this.mapHeaders(response.headers()), sidecarInstance));
        });
        return promise.future().toCompletionStage().toCompletableFuture();
    }

    @Override
    public CompletableFuture<HttpResponse> stream(SidecarInstance sidecarInstance, RequestContext context, StreamConsumer streamConsumer) {
        Objects.requireNonNull(streamConsumer, "The streamConsumer must be set");
        HttpRequest<Buffer> vertxRequest = this.vertxRequest(sidecarInstance, context);
        LOGGER.debug("Streaming request={}, from instance={}", (Object)context.request(), (Object)sidecarInstance);
        Promise promise = Promise.promise();
        vertxRequest.ssl(this.config.ssl()).timeout(this.config.timeoutMillis()).expect(response -> {
            promise.complete(new HttpResponseImpl(response.statusCode(), response.statusMessage(), this.mapHeaders(response.headers()), sidecarInstance));
            if (response.statusCode() == HttpResponseStatus.OK.code() || response.statusCode() == HttpResponseStatus.PARTIAL_CONTENT.code()) {
                return ResponsePredicateResult.success();
            }
            LOGGER.warn("Unexpected status code received statusCode={}, statusMessage={}", (Object)response.statusCode(), (Object)response.statusMessage());
            return ResponsePredicateResult.failure("Unexpected status code: " + response.statusCode());
        }).as(BodyCodec.pipe(new StreamConsumerWriteStream(streamConsumer))).send().onFailure(throwable -> {
            if (!promise.tryFail((Throwable)throwable)) {
                streamConsumer.onError((Throwable)throwable);
            }
        });
        return promise.future().toCompletionStage().toCompletableFuture();
    }

    @Override
    public void close() {
        this.webClient.close();
    }

    protected HttpRequest<Buffer> vertxRequest(SidecarInstance sidecarInstance, RequestContext context) {
        Request request = context.request();
        HttpMethod method = HttpMethod.valueOf(request.method().name());
        HttpRequest<Buffer> vertxRequest = this.webClient.request(method, sidecarInstance.port(), sidecarInstance.hostname(), request.requestURI());
        vertxRequest = this.applyHeaders(vertxRequest, request.headers());
        Map<String, String> customHeaders = context.customHeaders();
        if (customHeaders != null && !customHeaders.isEmpty()) {
            vertxRequest = this.applyHeaders(vertxRequest, customHeaders);
        }
        return vertxRequest;
    }

    protected HttpRequest<Buffer> applyHeaders(HttpRequest<Buffer> vertxRequest, Map<String, String> headers) {
        this.applyAuthHeader(vertxRequest);
        if (headers == null || headers.isEmpty()) {
            return vertxRequest;
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            vertxRequest = vertxRequest.putHeader(header.getKey(), header.getValue());
        }
        return vertxRequest;
    }

    private HttpRequest<Buffer> applyAuthHeader(HttpRequest<Buffer> vertxRequest) {
        if (StringUtils.isNullOrEmpty(this.config.cassandraRole())) {
            return vertxRequest;
        }
        vertxRequest = vertxRequest.putHeader("cassandra-auth-role", this.config.cassandraRole());
        return vertxRequest;
    }

    protected Map<String, List<String>> mapHeaders(MultiMap headers) {
        if (headers == null) {
            return Collections.emptyMap();
        }
        return headers.entries().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singletonList((String)entry.getValue())));
    }

    protected static WebClientOptions applySSLOptions(WebClientOptions options, HttpClientConfig config) {
        if (!config.ssl()) {
            return options;
        }
        options = options.setSsl(true);
        if (config.trustStoreInputStream() != null && config.trustStorePassword() != null) {
            KeyStoreOptions trustOptions = VertxHttpClient.buildKeyCertOptions(config.trustStoreInputStream(), config.trustStorePassword(), config.trustStoreType());
            options = options.setTrustOptions(trustOptions);
        }
        if (config.keyStoreInputStream() != null && config.keyStorePassword() != null) {
            KeyStoreOptions keyCertOptions = VertxHttpClient.buildKeyCertOptions(config.keyStoreInputStream(), config.keyStorePassword(), config.keyStoreType());
            options = options.setKeyCertOptions(keyCertOptions);
        }
        if (OpenSSLEngineOptions.isAvailable()) {
            LOGGER.info("Building Sidecar vertx client with OpenSSL");
            options = options.setOpenSslEngineOptions(new OpenSSLEngineOptions());
        } else {
            LOGGER.warn("OpenSSL not available when building Sidecar vertx client");
        }
        return options;
    }

    protected static KeyStoreOptions buildKeyCertOptions(InputStream storeStream, String storePass, String storeType) {
        KeyStoreOptions keyStoreOptions;
        block8: {
            InputStream inputStream = storeStream;
            try {
                byte[] trustBytes = VertxHttpClient.readStore(inputStream);
                keyStoreOptions = new KeyStoreOptions().setType(storeType).setPassword(storePass).setValue(Buffer.buffer(trustBytes));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load default truststore.", e);
                }
            }
            inputStream.close();
        }
        return keyStoreOptions;
    }

    protected static byte[] readStore(InputStream storeStream) throws IOException {
        int temp;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((temp = storeStream.read(buffer)) != -1) {
            bos.write(buffer, 0, temp);
        }
        return bos.toByteArray();
    }

    protected Future<AbstractMap.SimpleEntry<Long, AsyncFile>> openFileForRead(FileSystem fs, String filename) {
        Promise promise = Promise.promise();
        fs.exists(filename).compose(exists -> {
            if (!exists.booleanValue()) {
                String errMsg = "File '" + filename + "' does not exist";
                return Future.failedFuture(new NoSuchFileException(errMsg));
            }
            return fs.props(filename);
        }).onSuccess(props -> fs.open(filename, new OpenOptions().setWrite(false).setCreate(false).setRead(true)).onFailure(promise::tryFail).onSuccess(asyncFile -> promise.complete(new AbstractMap.SimpleEntry<Long, AsyncFile>(props.size(), (AsyncFile)asyncFile)))).onFailure(promise::tryFail);
        return promise.future();
    }
}

