/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.common.data;

import java.util.Objects;
import o.a.c.sidecar.client.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import o.a.c.sidecar.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;

public class StorageCredentials {
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;
    private final String region;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public StorageCredentials(@JsonProperty(value="accessKeyId") String accessKeyId, @JsonProperty(value="secretAccessKey") String secretAccessKey, @JsonProperty(value="sessionToken") String sessionToken, @JsonProperty(value="region") String region) {
        Objects.requireNonNull(accessKeyId, "accessKeyId must be supplied");
        Objects.requireNonNull(secretAccessKey, "secretAccessKey must be supplied");
        Objects.requireNonNull(sessionToken, "sessionToken must be supplied");
        Objects.requireNonNull(region, "region must be supplied");
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.sessionToken = sessionToken;
        this.region = region;
    }

    @JsonProperty(value="accessKeyId")
    public String accessKeyId() {
        return this.accessKeyId;
    }

    @JsonProperty(value="secretAccessKey")
    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    @JsonProperty(value="sessionToken")
    public String sessionToken() {
        return this.sessionToken;
    }

    @JsonProperty(value="region")
    public String region() {
        return this.region;
    }

    public String toString() {
        return String.format("StorageCredentials{%s=%s, %s=%s, %s=%s, %s=%s}", "accessKeyId", this.accessKeyId, "secretAccessKey", "redacted", "sessionToken", "redacted", "region", this.region);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StorageCredentials)) {
            return false;
        }
        StorageCredentials that = (StorageCredentials)obj;
        return Objects.equals(this.accessKeyId, that.accessKeyId) && Objects.equals(this.secretAccessKey, that.secretAccessKey) && Objects.equals(this.sessionToken, that.sessionToken) && Objects.equals(this.region, that.region);
    }

    public int hashCode() {
        return Objects.hash(this.accessKeyId, this.secretAccessKey, this.sessionToken, this.region);
    }

    public static class Builder {
        private String accessKeyId;
        private String secretAccessKey;
        private String sessionToken;
        private String region;

        private Builder() {
        }

        public Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public StorageCredentials build() {
            return new StorageCredentials(this.accessKeyId, this.secretAccessKey, this.sessionToken, this.region);
        }
    }
}

