/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.shrink;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.TypeResolutionStrategy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.apache.cassandra.analytics.TestConsistencyLevel;
import org.apache.cassandra.analytics.TestUninterruptibles;
import org.apache.cassandra.analytics.shrink.LeavingTestBase;
import org.apache.cassandra.distributed.api.Feature;
import org.apache.cassandra.distributed.api.ICluster;
import org.apache.cassandra.distributed.api.IInstance;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.spark.bulkwriter.WriterOptions;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class LeavingMultiDCHalveClusterTest
extends LeavingTestBase {
    static final int LEAVING_NODES_PER_DC = 3;

    LeavingMultiDCHalveClusterTest() {
    }

    @ParameterizedTest(name="{index} => {0}")
    @MethodSource(value={"multiDCTestInputs"})
    void testLeavingScenario(TestConsistencyLevel cl) {
        QualifiedName table = LeavingMultiDCHalveClusterTest.uniqueTestTableFullName("spark_test", cl.readCL, cl.writeCL);
        this.bulkWriterDataFrameWriter((Dataset<Row>)this.df, table).option(WriterOptions.BULK_WRITER_CL.name(), cl.writeCL.name()).save();
        this.validateData(table, cl.readCL, 1000);
        Map<IInstance, Set<String>> expectedInstanceData = this.generateExpectedInstanceData((ICluster<? extends IInstance>)this.cluster, this.leavingNodes, 1000);
        this.validateNodeSpecificData(table, expectedInstanceData, false);
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF3_DC2_RF3);
        LeavingMultiDCHalveClusterTest.multiDCTestInputs().forEach(arguments -> {
            QualifiedName tableName = LeavingMultiDCHalveClusterTest.uniqueTestTableFullName("spark_test", arguments.get());
            this.createTestTable(tableName, "CREATE TABLE IF NOT EXISTS %s (id int, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';");
        });
    }

    protected void beforeClusterShutdown() {
        this.completeTransitionsAndValidateWrites(BBHelperHalveClusterMultiDC.transitionalStateEnd, LeavingMultiDCHalveClusterTest.multiDCTestInputs());
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return LeavingMultiDCHalveClusterTest.clusterConfig().dcCount(2).nodesPerDc(6).requestFeature(Feature.NETWORK).requestFeature(Feature.GOSSIP).requestFeature(Feature.JMX).requestFeature(Feature.NATIVE_PROTOCOL).instanceInitializer(BBHelperHalveClusterMultiDC::install);
    }

    @Override
    protected int leavingNodesPerDc() {
        return 3;
    }

    @Override
    protected CountDownLatch transitioningStateStart() {
        return BBHelperHalveClusterMultiDC.transitionalStateStart;
    }

    public static class BBHelperHalveClusterMultiDC {
        static final CountDownLatch transitionalStateStart = new CountDownLatch(6);
        static final CountDownLatch transitionalStateEnd = new CountDownLatch(6);

        public static void install(ClassLoader cl, Integer nodeNumber) {
            if (nodeNumber > 6) {
                TypePool typePool = TypePool.Default.of((ClassLoader)cl);
                TypeDescription description = typePool.describe("org.apache.cassandra.service.StorageService").resolve();
                new ByteBuddy().rebase(description, ClassFileLocator.ForClassLoader.of((ClassLoader)cl)).method((ElementMatcher)ElementMatchers.named((String)"unbootstrap")).intercept((Implementation)MethodDelegation.to(BBHelperHalveClusterMultiDC.class)).make((TypeResolutionStrategy)TypeResolutionStrategy.Lazy.INSTANCE, typePool).load(cl, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
            }
        }

        public static void unbootstrap(@SuperCall Callable<?> orig) throws Exception {
            transitionalStateStart.countDown();
            TestUninterruptibles.awaitUninterruptiblyOrThrow(transitionalStateEnd, 4L, TimeUnit.MINUTES);
            orig.call();
        }
    }
}

