/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.math.BigInteger;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.dht.Token;

public class TokenUtils {
    protected TokenUtils() {
    }

    public static BigInteger tokenToBigInteger(Token token) {
        if (token instanceof Murmur3Partitioner.LongToken) {
            return BigInteger.valueOf((Long)token.getTokenValue());
        }
        if (token instanceof RandomPartitioner.BigIntegerToken) {
            return (BigInteger)((RandomPartitioner.BigIntegerToken)token).getTokenValue();
        }
        throw new UnsupportedOperationException("Unexpected token type: " + token.getClass().getName());
    }

    public static long tokenToLong(Token token) {
        if (token instanceof Murmur3Partitioner.LongToken) {
            return (Long)token.getTokenValue();
        }
        if (token instanceof RandomPartitioner.BigIntegerToken) {
            return ((BigInteger)((RandomPartitioner.BigIntegerToken)token).getTokenValue()).longValue();
        }
        throw new UnsupportedOperationException("Unexpected token type: " + token.getClass().getName());
    }
}

