/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.Arrays;
import java.util.function.IntUnaryOperator;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.IntIntConsumer;

public class Int2IntCounterMap {
    private static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final int initialValue;
    private int resizeThreshold;
    private int size = 0;
    private int[] entries;

    public Int2IntCounterMap(int initialValue) {
        this(8, 0.65f, initialValue);
    }

    public Int2IntCounterMap(int initialCapacity, float loadFactor, int initialValue) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.initialValue = initialValue;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity)));
    }

    public int initialValue() {
        return this.initialValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public int capacity() {
        return this.entries.length >> 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return 0 == this.size;
    }

    public int get(int key) {
        int value;
        int initialValue = this.initialValue;
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (initialValue != (value = entries[index + 1]) && key != entries[index]) {
            index = Int2IntCounterMap.next(index, mask);
        }
        return value;
    }

    public int put(int key, int value) {
        int oldValue;
        int initialValue = this.initialValue;
        if (initialValue == value) {
            throw new IllegalArgumentException("cannot accept initialValue");
        }
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (initialValue != (oldValue = entries[index + 1]) && key != entries[index]) {
            index = Int2IntCounterMap.next(index, mask);
        }
        if (initialValue == oldValue) {
            ++this.size;
            entries[index] = key;
        }
        entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    public int incrementAndGet(int key) {
        return this.addAndGet(key, 1);
    }

    public int decrementAndGet(int key) {
        return this.addAndGet(key, -1);
    }

    public int addAndGet(int key, int amount) {
        return this.getAndAdd(key, amount) + amount;
    }

    public int getAndIncrement(int key) {
        return this.getAndAdd(key, 1);
    }

    public int getAndDecrement(int key) {
        return this.getAndAdd(key, -1);
    }

    public int getAndAdd(int key, int amount) {
        int oldValue;
        int initialValue = this.initialValue;
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (initialValue != (oldValue = entries[index + 1]) && key != entries[index]) {
            index = Int2IntCounterMap.next(index, mask);
        }
        if (amount != 0) {
            int newValue;
            entries[index + 1] = newValue = oldValue + amount;
            if (initialValue == oldValue) {
                ++this.size;
                entries[index] = key;
                this.increaseCapacity();
            } else if (initialValue == newValue) {
                --this.size;
                this.compactChain(index);
            }
        }
        return oldValue;
    }

    public void forEach(IntIntConsumer consumer) {
        int initialValue = this.initialValue;
        int[] entries = this.entries;
        int length = entries.length;
        int remaining = this.size;
        for (int i = 1; remaining > 0 && i < length; i += 2) {
            int value = entries[i];
            if (initialValue == value) continue;
            consumer.accept(entries[i - 1], value);
            --remaining;
        }
    }

    public boolean containsKey(int key) {
        return this.initialValue != this.get(key);
    }

    public boolean containsValue(int value) {
        boolean found = false;
        if (this.initialValue != value) {
            int[] entries = this.entries;
            int length = entries.length;
            for (int i = 1; i < length; i += 2) {
                if (value != entries[i]) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.entries, this.initialValue);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    public int computeIfAbsent(int key, IntUnaryOperator mappingFunction) {
        int value = this.get(key);
        if (this.initialValue == value && this.initialValue != (value = mappingFunction.applyAsInt(key))) {
            this.put(key, value);
        }
        return value;
    }

    public int remove(int key) {
        int oldValue;
        int initialValue = this.initialValue;
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        while (initialValue != (oldValue = entries[keyIndex + 1])) {
            if (key == entries[keyIndex]) {
                entries[keyIndex + 1] = initialValue;
                --this.size;
                this.compactChain(keyIndex);
                break;
            }
            keyIndex = Int2IntCounterMap.next(keyIndex, mask);
        }
        return oldValue;
    }

    public int minValue() {
        int initialValue = this.initialValue;
        int min2 = 0 == this.size ? initialValue : Integer.MAX_VALUE;
        int[] entries = this.entries;
        int length = entries.length;
        for (int i = 1; i < length; i += 2) {
            int value = entries[i];
            if (initialValue == value) continue;
            min2 = Math.min(min2, value);
        }
        return min2;
    }

    public int maxValue() {
        int initialValue = this.initialValue;
        int max = 0 == this.size ? initialValue : Integer.MIN_VALUE;
        int[] entries = this.entries;
        int length = entries.length;
        for (int i = 1; i < length; i += 2) {
            int value = entries[i];
            if (initialValue == value) continue;
            max = Math.max(max, value);
        }
        return max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int initialValue = this.initialValue;
        int[] entries = this.entries;
        int length = entries.length;
        for (int i = 1; i < length; i += 2) {
            int value = entries[i];
            if (initialValue == value) continue;
            sb.append(entries[i - 1]).append('=').append(value).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void compactChain(int deleteKeyIndex) {
        int value;
        int initialValue = this.initialValue;
        int[] entries = this.entries;
        int mask = entries.length - 1;
        int index = deleteKeyIndex;
        while (initialValue != (value = entries[(index = Int2IntCounterMap.next(index, mask)) + 1])) {
            int key = entries[index];
            int hash = Hashing.evenHash(key, mask);
            if ((index >= hash || hash > deleteKeyIndex && deleteKeyIndex > index) && (hash > deleteKeyIndex || deleteKeyIndex > index)) continue;
            entries[deleteKeyIndex] = key;
            entries[deleteKeyIndex + 1] = value;
            entries[index + 1] = initialValue;
            deleteKeyIndex = index;
        }
    }

    private void capacity(int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = new int[entriesLength];
        Arrays.fill(this.entries, this.initialValue);
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(int newCapacity) {
        int initialValue = this.initialValue;
        int[] oldEntries = this.entries;
        int length = oldEntries.length;
        this.capacity(newCapacity);
        int[] newEntries = this.entries;
        int mask = newEntries.length - 1;
        for (int keyIndex = 0; keyIndex < length; keyIndex += 2) {
            int value = oldEntries[keyIndex + 1];
            if (initialValue == value) continue;
            int key = oldEntries[keyIndex];
            int index = Hashing.evenHash(key, mask);
            while (initialValue != newEntries[index + 1]) {
                index = Int2IntCounterMap.next(index, mask);
            }
            newEntries[index] = key;
            newEntries[index + 1] = value;
        }
    }
}

