/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.selection.Selectable;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.NumberType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.VectorType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public interface FunctionParameter {
    @Nullable
    default public AbstractType<?> inferType(String keyspace, AssignmentTestable arg, @Nullable AbstractType<?> receiverType, @Nullable List<AbstractType<?>> inferredTypes) {
        return arg.getCompatibleTypeIfKnown(keyspace);
    }

    public void validateType(FunctionName var1, AssignmentTestable var2, AbstractType<?> var3);

    default public boolean isOptional() {
        return false;
    }

    public static FunctionParameter optional(final FunctionParameter wrapped) {
        return new FunctionParameter(){

            @Override
            @Nullable
            public AbstractType<?> inferType(String keyspace, AssignmentTestable arg, @Nullable AbstractType<?> receiverType, @Nullable List<AbstractType<?>> inferredTypes) {
                return wrapped.inferType(keyspace, arg, receiverType, inferredTypes);
            }

            @Override
            public void validateType(FunctionName name, AssignmentTestable arg, AbstractType<?> argType) {
                wrapped.validateType(name, arg, argType);
            }

            @Override
            public boolean isOptional() {
                return true;
            }

            public String toString() {
                return "[" + wrapped.toString() + "]";
            }
        };
    }

    public static FunctionParameter string() {
        return FunctionParameter.fixed(CQL3Type.Native.TEXT, CQL3Type.Native.VARCHAR, CQL3Type.Native.ASCII);
    }

    public static FunctionParameter fixed(final CQL3Type ... types) {
        if (!10.$assertionsDisabled && types.length <= 0) {
            throw new AssertionError();
        }
        return new FunctionParameter(){

            @Override
            public AbstractType<?> inferType(String keyspace, AssignmentTestable arg, @Nullable AbstractType<?> receiverType, @Nullable List<AbstractType<?>> inferredTypes) {
                AbstractType<?> inferred = arg.getCompatibleTypeIfKnown(keyspace);
                return inferred != null ? inferred : types[0].getType();
            }

            @Override
            public void validateType(FunctionName name, AssignmentTestable arg, AbstractType<?> argType) {
                if (Arrays.stream(types).allMatch(t2 -> argType.testAssignment(t2.getType()) == AssignmentTestable.TestResult.NOT_ASSIGNABLE)) {
                    throw new InvalidRequestException(String.format("Function %s requires an argument of type %s, but found argument %s of type %s", name, this, arg, argType.asCQL3Type()));
                }
            }

            public String toString() {
                if (types.length == 1) {
                    return types[0].toString();
                }
                return "[" + Arrays.stream(types).map(Object::toString).collect(Collectors.joining("|")) + "]";
            }
        };
    }

    public static FunctionParameter anyType(final boolean inferFromReceiver) {
        return new FunctionParameter(){

            @Override
            public AbstractType<?> inferType(String keyspace, AssignmentTestable arg, @Nullable AbstractType<?> receiverType, @Nullable List<AbstractType<?>> inferredTypes) {
                AbstractType<?> type = arg.getCompatibleTypeIfKnown(keyspace);
                return type == null && inferFromReceiver ? receiverType : type;
            }

            @Override
            public void validateType(FunctionName name, AssignmentTestable arg, AbstractType<?> argType) {
            }

            public String toString() {
                return "any";
            }
        };
    }

    public static FunctionParameter sameAs(final int index, final boolean preferOther, final FunctionParameter parameter) {
        return new FunctionParameter(){

            @Override
            public AbstractType<?> inferType(String keyspace, AssignmentTestable arg, @Nullable AbstractType<?> receiverType, @Nullable List<AbstractType<?>> inferredTypes) {
                if (preferOther) {
                    AbstractType<?> other = inferredTypes == null ? null : inferredTypes.get(index);
                    return other == null ? parameter.inferType(keyspace, arg, receiverType, inferredTypes) : other;
                }
                AbstractType<?> inferred = parameter.inferType(keyspace, arg, receiverType, inferredTypes);
                return inferred == null && inferredTypes != null ? inferredTypes.get(index) : inferred;
            }

            @Override
            public void validateType(FunctionName name, AssignmentTestable arg, AbstractType<?> argType) {
                parameter.validateType(name, arg, argType);
            }

            public String toString() {
                return parameter.toString();
            }
        };
    }

    public static FunctionParameter anyCollection() {
        return new FunctionParameter(){

            @Override
            public void validateType(FunctionName name, AssignmentTestable arg, AbstractType<?> argType) {
                if (!argType.isCollection()) {
                    throw new InvalidRequestException(String.format("Function %s requires a collection argument, but found argument %s of type %s", name, arg, argType.asCQL3Type()));
                }
            }

            public String toString() {
                return "collection";
            }
        };
    }

    public static FunctionParameter setOrList() {
        return new FunctionParameter(){

            @Override
            public void validateType(FunctionName name, AssignmentTestable arg, AbstractType<?> argType) {
                CollectionType.Kind kind;
                if (argType.isCollection() && ((kind = ((CollectionType)argType).kind) == CollectionType.Kind.SET || kind == CollectionType.Kind.LIST)) {
                    return;
                }
                throw new InvalidRequestException(String.format("Function %s requires a set or list argument, but found argument %s of type %s", name, arg, argType.asCQL3Type()));
            }

            public String toString() {
                return "numeric_set_or_list";
            }
        };
    }

    public static FunctionParameter numericSetOrList() {
        return new FunctionParameter(){

            @Override
            public void validateType(FunctionName name, AssignmentTestable arg, AbstractType<?> argType) {
                AbstractType elementType = null;
                if (argType.isCollection()) {
                    CollectionType collectionType = (CollectionType)argType;
                    if (collectionType.kind == CollectionType.Kind.SET) {
                        elementType = ((SetType)argType).getElementsType();
                    } else if (collectionType.kind == CollectionType.Kind.LIST) {
                        elementType = ((ListType)argType).getElementsType();
                    }
                }
                if (!(elementType instanceof NumberType)) {
                    throw new InvalidRequestException(String.format("Function %s requires a numeric set/list argument, but found argument %s of type %s", name, arg, argType.asCQL3Type()));
                }
            }

            public String toString() {
                return "numeric_set_or_list";
            }
        };
    }

    public static FunctionParameter anyMap() {
        return new FunctionParameter(){

            @Override
            public void validateType(FunctionName name, AssignmentTestable arg, AbstractType<?> argType) {
                if (!argType.isUDT() && !(argType instanceof MapType)) {
                    throw new InvalidRequestException(String.format("Function %s requires a map argument, but found argument %s of type %s", name, arg, argType.asCQL3Type()));
                }
            }

            public String toString() {
                return "map";
            }
        };
    }

    public static FunctionParameter vector(final CQL3Type type) {
        return new FunctionParameter(){

            @Override
            public AbstractType<?> inferType(String keyspace, AssignmentTestable arg, @Nullable AbstractType<?> receiverType, @Nullable List<AbstractType<?>> inferredTypes) {
                if (arg instanceof Selectable.WithArrayLiteral) {
                    return VectorType.getInstance(type.getType(), ((Selectable.WithArrayLiteral)arg).getSize());
                }
                AbstractType<?> inferred = arg.getCompatibleTypeIfKnown(keyspace);
                return inferred == null ? receiverType : inferred;
            }

            @Override
            public void validateType(FunctionName name, AssignmentTestable arg, AbstractType<?> argType) {
                ListType listType;
                if (argType.isVector()) {
                    VectorType vectorType = (VectorType)argType;
                    if (vectorType.elementType.asCQL3Type() == type) {
                        return;
                    }
                } else if (argType instanceof ListType && (listType = (ListType)argType).getElementsType().testAssignment(type.getType()) == AssignmentTestable.TestResult.NOT_ASSIGNABLE) {
                    return;
                }
                throw new InvalidRequestException(String.format("Function %s requires a %s vector argument, but found argument %s of type %s", name, type, arg, argType.asCQL3Type()));
            }

            public String toString() {
                return String.format("vector<%s, n>", type);
            }
        };
    }

    static {
        if (10.$assertionsDisabled) {
            // empty if block
        }
    }
}

