/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.selection.AggregateFunctionSelector;
import org.apache.cassandra.cql3.selection.ColumnTimestamps;
import org.apache.cassandra.cql3.selection.ElementsSelector;
import org.apache.cassandra.cql3.selection.FieldSelector;
import org.apache.cassandra.cql3.selection.ListSelector;
import org.apache.cassandra.cql3.selection.MapSelector;
import org.apache.cassandra.cql3.selection.RowTimestamps;
import org.apache.cassandra.cql3.selection.ScalarFunctionSelector;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.SetSelector;
import org.apache.cassandra.cql3.selection.SimpleSelector;
import org.apache.cassandra.cql3.selection.TermSelector;
import org.apache.cassandra.cql3.selection.TupleSelector;
import org.apache.cassandra.cql3.selection.UserTypeSelector;
import org.apache.cassandra.cql3.selection.VectorSelector;
import org.apache.cassandra.cql3.selection.WritetimeOrTTLSelector;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.CQLTypeParser;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class Selector {
    public static final Serializer serializer = new Serializer();
    private final Kind kind;

    public final Kind kind() {
        return this.kind;
    }

    protected Selector(Kind kind) {
        this.kind = kind;
    }

    public abstract void addFetchedColumns(ColumnFilter.Builder var1);

    public abstract void addInput(InputRow var1);

    public abstract ByteBuffer getOutput(ProtocolVersion var1) throws InvalidRequestException;

    protected ColumnTimestamps getWritetimes(ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    protected ColumnTimestamps getTTLs(ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    public abstract AbstractType<?> getType();

    public abstract void reset();

    public boolean isTerminal() {
        return false;
    }

    public void validateForGroupBy() {
        throw RequestValidations.invalidRequest("Only column names and monotonic scalar functions are supported in the GROUP BY clause.");
    }

    protected abstract int serializedSize(int var1);

    protected abstract void serialize(DataOutputPlus var1, int var2) throws IOException;

    protected static void writeType(DataOutputPlus out, AbstractType<?> type) throws IOException {
        out.writeUTF(type.asCQL3Type().toString());
    }

    protected static int sizeOf(AbstractType<?> type) {
        return TypeSizes.sizeof(type.asCQL3Type().toString());
    }

    public static final class InputRow {
        private final ProtocolVersion protocolVersion;
        private final List<ColumnMetadata> columns;
        private final boolean unmask;
        private final boolean collectWritetimes;
        private final boolean collectTTLs;
        private ByteBuffer[] values;
        private RowTimestamps writetimes;
        private RowTimestamps ttls;
        private int index;

        public InputRow(ProtocolVersion protocolVersion, List<ColumnMetadata> columns, boolean unmask) {
            this(protocolVersion, columns, unmask, false, false);
        }

        public InputRow(ProtocolVersion protocolVersion, List<ColumnMetadata> columns, boolean unmask, boolean collectWritetimes, boolean collectTTLs) {
            this.protocolVersion = protocolVersion;
            this.columns = columns;
            this.unmask = unmask;
            this.collectWritetimes = collectWritetimes;
            this.collectTTLs = collectTTLs;
            this.values = new ByteBuffer[columns.size()];
            this.writetimes = this.initTimestamps(ColumnTimestamps.TimestampsType.WRITETIMES, collectWritetimes, columns);
            this.ttls = this.initTimestamps(ColumnTimestamps.TimestampsType.TTLS, collectTTLs, columns);
        }

        private RowTimestamps initTimestamps(ColumnTimestamps.TimestampsType type, boolean collectWritetimes, List<ColumnMetadata> columns) {
            return collectWritetimes ? RowTimestamps.newInstance(type, columns) : RowTimestamps.NOOP_ROW_TIMESTAMPS;
        }

        public ProtocolVersion getProtocolVersion() {
            return this.protocolVersion;
        }

        public boolean unmask() {
            return this.unmask;
        }

        public void add(ByteBuffer v) {
            this.values[this.index] = v;
            if (v != null) {
                this.writetimes.addNoTimestamp(this.index);
                this.ttls.addNoTimestamp(this.index);
            }
            ++this.index;
        }

        public void add(ColumnData columnData, long nowInSec) {
            ColumnMetadata column = this.columns.get(this.index);
            if (columnData == null) {
                this.add(null);
            } else if (column.isComplex()) {
                this.add((ComplexColumnData)columnData, nowInSec);
            } else {
                this.add((Cell)columnData, nowInSec);
            }
        }

        private void add(Cell<?> c, long nowInSec) {
            this.values[this.index] = this.value(c);
            this.writetimes.addTimestamp(this.index, c, nowInSec);
            this.ttls.addTimestamp(this.index, c, nowInSec);
            ++this.index;
        }

        private void add(ComplexColumnData ccd, long nowInSec) {
            AbstractType type = this.columns.get((int)this.index).type;
            if (type.isCollection()) {
                this.values[this.index] = ((CollectionType)type).serializeForNativeProtocol(ccd.iterator());
                for (Cell<?> cell : ccd) {
                    this.writetimes.addTimestamp(this.index, cell, nowInSec);
                    this.ttls.addTimestamp(this.index, cell, nowInSec);
                }
            } else {
                UserType udt = (UserType)type;
                int size = udt.size();
                this.values[this.index] = udt.serializeForNativeProtocol(ccd.iterator(), this.protocolVersion);
                int fieldPosition = 0;
                for (Cell<?> cell : ccd) {
                    short fieldPositionOfCell = ByteBufferUtil.toShort(cell.path().get(0));
                    while (fieldPosition < fieldPositionOfCell) {
                        fieldPosition = (short)(fieldPosition + 1);
                        this.writetimes.addNoTimestamp(this.index);
                        this.ttls.addNoTimestamp(this.index);
                    }
                    fieldPosition = (short)(fieldPosition + 1);
                    this.writetimes.addTimestamp(this.index, cell, nowInSec);
                    this.ttls.addTimestamp(this.index, cell, nowInSec);
                }
                while (fieldPosition < size) {
                    fieldPosition = (short)(fieldPosition + 1);
                    this.writetimes.addNoTimestamp(this.index);
                    this.ttls.addNoTimestamp(this.index);
                }
            }
            ++this.index;
        }

        private <V> ByteBuffer value(Cell<V> c) {
            return c.isCounterCell() ? ByteBufferUtil.bytes(CounterContext.instance().total(c.value(), c.accessor())) : c.buffer();
        }

        public ByteBuffer getValue(int index) {
            return this.values[index];
        }

        public void reset(boolean deep) {
            this.index = 0;
            this.writetimes = this.initTimestamps(ColumnTimestamps.TimestampsType.WRITETIMES, this.collectWritetimes, this.columns);
            this.ttls = this.initTimestamps(ColumnTimestamps.TimestampsType.TTLS, this.collectTTLs, this.columns);
            if (deep) {
                this.values = new ByteBuffer[this.values.length];
            }
        }

        ColumnTimestamps getWritetimes(int columnIndex) {
            return this.writetimes.get(columnIndex);
        }

        ColumnTimestamps getTtls(int columnIndex) {
            return this.ttls.get(columnIndex);
        }

        public List<ByteBuffer> getValues() {
            return Arrays.asList(this.values);
        }
    }

    public static class Serializer {
        public void serialize(Selector selector, DataOutputPlus out, int version) throws IOException {
            out.writeByte(selector.kind().ordinal());
            selector.serialize(out, version);
        }

        public Selector deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            Kind kind = Kind.values()[in.readUnsignedByte()];
            return kind.deserializer.deserialize(in, version, metadata);
        }

        public int serializedSize(Selector selector, int version) {
            return TypeSizes.sizeof((byte)selector.kind().ordinal()) + selector.serializedSize(version);
        }
    }

    public static abstract class Factory {
        public void addFunctionsTo(List<Function> functions) {
        }

        public ColumnSpecification getColumnSpecification(TableMetadata table) {
            return new ColumnSpecification(table.keyspace, table.name, new ColumnIdentifier(this.getColumnName(), true), this.getReturnType());
        }

        public abstract Selector newInstance(QueryOptions var1);

        public boolean isAggregateSelectorFactory() {
            return false;
        }

        public boolean isWritetimeSelectorFactory() {
            return false;
        }

        public boolean isMaxWritetimeSelectorFactory() {
            return false;
        }

        public boolean isTTLSelectorFactory() {
            return false;
        }

        public boolean isSimpleSelectorFactory() {
            return false;
        }

        public boolean isSimpleSelectorFactoryFor(int index) {
            return false;
        }

        protected abstract String getColumnName();

        protected abstract AbstractType<?> getReturnType();

        protected abstract void addColumnMapping(SelectionColumnMapping var1, ColumnSpecification var2);

        abstract boolean areAllFetchedColumnsKnown();

        abstract void addFetchedColumns(ColumnFilter.Builder var1);
    }

    public static enum Kind {
        SIMPLE_SELECTOR(SimpleSelector.deserializer),
        TERM_SELECTOR(TermSelector.deserializer),
        WRITETIME_OR_TTL_SELECTOR(WritetimeOrTTLSelector.deserializer),
        LIST_SELECTOR(ListSelector.deserializer),
        SET_SELECTOR(SetSelector.deserializer),
        MAP_SELECTOR(MapSelector.deserializer),
        TUPLE_SELECTOR(TupleSelector.deserializer),
        USER_TYPE_SELECTOR(UserTypeSelector.deserializer),
        FIELD_SELECTOR(FieldSelector.deserializer),
        SCALAR_FUNCTION_SELECTOR(ScalarFunctionSelector.deserializer),
        AGGREGATE_FUNCTION_SELECTOR(AggregateFunctionSelector.deserializer),
        ELEMENT_SELECTOR(ElementsSelector.ElementSelector.deserializer),
        SLICE_SELECTOR(ElementsSelector.SliceSelector.deserializer),
        VECTOR_SELECTOR(VectorSelector.deserializer);

        private final SelectorDeserializer deserializer;

        private Kind(SelectorDeserializer deserializer) {
            this.deserializer = deserializer;
        }
    }

    protected static abstract class SelectorDeserializer {
        protected SelectorDeserializer() {
        }

        protected abstract Selector deserialize(DataInputPlus var1, int var2, TableMetadata var3) throws IOException;

        protected final AbstractType<?> readType(TableMetadata metadata, DataInputPlus in) throws IOException {
            KeyspaceMetadata keyspace = Schema.instance.getKeyspaceMetadata(metadata.keyspace);
            return this.readType(keyspace, in);
        }

        protected final AbstractType<?> readType(KeyspaceMetadata keyspace, DataInputPlus in) throws IOException {
            String cqlType = in.readUTF();
            return CQLTypeParser.parse(keyspace.name, cqlType, keyspace.types);
        }
    }
}

