/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundary;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.io.sstable.IndexInfo;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

public class ClusteringComparator
implements Comparator<Clusterable> {
    private final List<AbstractType<?>> clusteringTypes;
    private final Comparator<IndexInfo> indexComparator;
    private final Comparator<IndexInfo> indexReverseComparator;
    private final Comparator<Clusterable> reverseComparator;
    private final Comparator<Row> rowComparator = (r1, r2) -> this.compare(r1.clustering(), r2.clustering());

    public ClusteringComparator(AbstractType<?> ... clusteringTypes) {
        this(ImmutableList.copyOf(clusteringTypes));
    }

    public ClusteringComparator(Iterable<AbstractType<?>> clusteringTypes) {
        this.clusteringTypes = ImmutableList.copyOf(clusteringTypes);
        this.indexComparator = (o1, o2) -> this.compare(o1.lastName, o2.lastName);
        this.indexReverseComparator = (o1, o2) -> this.compare(o1.firstName, o2.firstName);
        this.reverseComparator = (c1, c2) -> this.compare((Clusterable)c2, (Clusterable)c1);
        for (AbstractType<?> type : clusteringTypes) {
            type.checkComparable();
        }
    }

    public int size() {
        return this.clusteringTypes.size();
    }

    public List<AbstractType<?>> subtypes() {
        return this.clusteringTypes;
    }

    public AbstractType<?> subtype(int i) {
        return this.clusteringTypes.get(i);
    }

    public Clustering<?> make(Object ... values) {
        if (values.length != this.size()) {
            throw new IllegalArgumentException(String.format("Invalid number of components, expecting %d but got %d", this.size(), values.length));
        }
        CBuilder builder = CBuilder.create(this);
        for (Object val : values) {
            if (val instanceof ByteBuffer) {
                builder.add((ByteBuffer)val);
                continue;
            }
            builder.add(val);
        }
        return builder.build();
    }

    @Override
    public int compare(Clusterable c1, Clusterable c2) {
        return this.compare(c1.clustering(), c2.clustering());
    }

    @Override
    public <V1, V2> int compare(ClusteringPrefix<V1> c1, ClusteringPrefix<V2> c2) {
        int s1 = c1.size();
        int s2 = c2.size();
        int minSize = Math.min(s1, s2);
        for (int i = 0; i < minSize; ++i) {
            int cmp = this.compareComponent(i, c1.get(i), c1.accessor(), c2.get(i), c2.accessor());
            if (cmp == 0) continue;
            return cmp;
        }
        if (s1 == s2) {
            return ClusteringPrefix.Kind.compare(c1.kind(), c2.kind());
        }
        return s1 < s2 ? c1.kind().comparedToClustering : -c2.kind().comparedToClustering;
    }

    @Override
    public <V1, V2> int compare(Clustering<V1> c1, Clustering<V2> c2) {
        return this.compare(c1, c2, this.size());
    }

    public <V1, V2> int compare(Clustering<V1> c1, Clustering<V2> c2, int size) {
        for (int i = 0; i < size; ++i) {
            int cmp = this.compareComponent(i, c1.get(i), c1.accessor(), c2.get(i), c2.accessor());
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public <V1, V2> int compareComponent(int i, V1 v1, ValueAccessor<V1> accessor1, V2 v2, ValueAccessor<V2> accessor2) {
        if (v1 == null) {
            return v2 == null ? 0 : -1;
        }
        if (v2 == null) {
            return 1;
        }
        return this.clusteringTypes.get(i).compare(v1, accessor1, v2, accessor2);
    }

    public <V1, V2> int compareComponent(int i, ClusteringPrefix<V1> v1, ClusteringPrefix<V2> v2) {
        return this.compareComponent(i, v1.get(i), v1.accessor(), v2.get(i), v2.accessor());
    }

    public boolean isCompatibleWith(ClusteringComparator previous) {
        if (this == previous) {
            return true;
        }
        if (this.size() < previous.size()) {
            return false;
        }
        for (int i = 0; i < previous.size(); ++i) {
            AbstractType<?> tprev = previous.subtype(i);
            AbstractType<?> tnew = this.subtype(i);
            if (tnew.isCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    public <T> void validate(ClusteringPrefix<T> clustering) {
        ValueAccessor<T> accessor = clustering.accessor();
        for (int i = 0; i < clustering.size(); ++i) {
            T value = clustering.get(i);
            if (value == null) continue;
            this.subtype(i).validate(value, accessor);
        }
    }

    public <V> ByteComparable asByteComparable(ClusteringPrefix<V> clustering) {
        return new ByteComparableClustering<V>(clustering);
    }

    public <V> Clustering<V> clusteringFromByteComparable(ValueAccessor<V> accessor, ByteComparable comparable) {
        ByteComparable.Version version = ByteComparable.Version.OSS50;
        ByteSource.Peekable orderedBytes = ByteSource.peekable(comparable.asComparableBytes(version));
        if (orderedBytes == null) {
            return null;
        }
        int sep = orderedBytes.next();
        switch (sep) {
            case 56: {
                assert (this.size() == 0) : "Terminator should be after " + this.size() + " components, got 0";
                return accessor.factory().clustering();
            }
            case 24: {
                return accessor.factory().staticClustering();
            }
        }
        int cc = 0;
        V[] components = accessor.createArray(this.size());
        while (true) {
            switch (sep) {
                case 62: {
                    components[cc] = null;
                    break;
                }
                case 63: 
                case 65: {
                    components[cc] = this.subtype(cc).fromComparableBytes(accessor, null, version);
                    break;
                }
                case 64: {
                    components[cc] = this.subtype(cc).fromComparableBytes(accessor, orderedBytes, version);
                    break;
                }
                case 56: {
                    assert (cc == this.size()) : "Terminator should be after " + this.size() + " components, got " + cc;
                    return accessor.factory().clustering(components);
                }
                case 24: {
                    throw new AssertionError((Object)"Unexpected static terminator after the first component");
                }
                default: {
                    throw new AssertionError((Object)("Unexpected separator " + Integer.toHexString(sep) + " in Clustering encoding"));
                }
            }
            ++cc;
            sep = orderedBytes.next();
        }
    }

    public <V> ClusteringBound<V> boundFromByteComparable(ValueAccessor<V> accessor, ByteComparable comparable, boolean isEnd) {
        ByteComparable.Version version = ByteComparable.Version.OSS50;
        ByteSource.Peekable orderedBytes = ByteSource.peekable(comparable.asComparableBytes(version));
        int sep = orderedBytes.next();
        int cc = 0;
        V[] components = accessor.createArray(this.size());
        while (true) {
            switch (sep) {
                case 62: {
                    components[cc] = null;
                    break;
                }
                case 63: 
                case 65: {
                    components[cc] = this.subtype(cc).fromComparableBytes(accessor, null, version);
                    break;
                }
                case 64: {
                    components[cc] = this.subtype(cc).fromComparableBytes(accessor, orderedBytes, version);
                    break;
                }
                case 32: {
                    return accessor.factory().bound(isEnd ? ClusteringPrefix.Kind.EXCL_END_BOUND : ClusteringPrefix.Kind.INCL_START_BOUND, Arrays.copyOf(components, cc));
                }
                case 96: {
                    return accessor.factory().bound(isEnd ? ClusteringPrefix.Kind.INCL_END_BOUND : ClusteringPrefix.Kind.EXCL_START_BOUND, Arrays.copyOf(components, cc));
                }
                case 31: 
                case 97: {
                    throw new AssertionError((Object)"Unexpected sstable lower/upper bound - byte comparable representation of artificial sstable bounds is not supported");
                }
                default: {
                    throw new AssertionError((Object)("Unexpected separator " + Integer.toHexString(sep) + " in ClusteringBound encoding"));
                }
            }
            ++cc;
            sep = orderedBytes.next();
        }
    }

    public <V> ClusteringBoundary<V> boundaryFromByteComparable(ValueAccessor<V> accessor, ByteComparable comparable) {
        ByteComparable.Version version = ByteComparable.Version.OSS50;
        ByteSource.Peekable orderedBytes = ByteSource.peekable(comparable.asComparableBytes(version));
        int sep = orderedBytes.next();
        int cc = 0;
        V[] components = accessor.createArray(this.size());
        while (true) {
            switch (sep) {
                case 62: {
                    components[cc] = null;
                    break;
                }
                case 63: 
                case 65: {
                    components[cc] = this.subtype(cc).fromComparableBytes(accessor, null, version);
                    break;
                }
                case 64: {
                    components[cc] = this.subtype(cc).fromComparableBytes(accessor, orderedBytes, version);
                    break;
                }
                case 32: {
                    return accessor.factory().boundary(ClusteringPrefix.Kind.EXCL_END_INCL_START_BOUNDARY, Arrays.copyOf(components, cc));
                }
                case 96: {
                    return accessor.factory().boundary(ClusteringPrefix.Kind.INCL_END_EXCL_START_BOUNDARY, Arrays.copyOf(components, cc));
                }
                default: {
                    throw new AssertionError((Object)("Unexpected separator " + Integer.toHexString(sep) + " in ClusteringBoundary encoding"));
                }
            }
            ++cc;
            sep = orderedBytes.next();
        }
    }

    public Comparator<Row> rowComparator() {
        return this.rowComparator;
    }

    public Comparator<IndexInfo> indexComparator(boolean reversed) {
        return reversed ? this.indexReverseComparator : this.indexComparator;
    }

    @Override
    public Comparator<Clusterable> reversed() {
        return this.reverseComparator;
    }

    public String toString() {
        return String.format("comparator(%s)", Joiner.on(", ").join(this.clusteringTypes));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusteringComparator)) {
            return false;
        }
        ClusteringComparator that = (ClusteringComparator)o;
        return this.clusteringTypes.equals(that.clusteringTypes);
    }

    public int hashCode() {
        return Objects.hashCode(this.clusteringTypes);
    }

    private class ByteComparableClustering<V>
    implements ByteComparable {
        private final ClusteringPrefix<V> src;

        ByteComparableClustering(ClusteringPrefix<V> src) {
            this.src = src;
        }

        @Override
        public ByteSource asComparableBytes(final ByteComparable.Version version) {
            return new ByteSource(){
                private ByteSource current = null;
                private int srcnum = -1;

                @Override
                public int next() {
                    int sz;
                    if (this.current != null) {
                        int b = this.current.next();
                        if (b > -1) {
                            return b;
                        }
                        this.current = null;
                    }
                    if (this.srcnum == (sz = ByteComparableClustering.this.src.size())) {
                        return -1;
                    }
                    ++this.srcnum;
                    if (this.srcnum == sz) {
                        return ByteComparableClustering.this.src.kind().asByteComparableValue(version);
                    }
                    Object nextComponent = ByteComparableClustering.this.src.get(this.srcnum);
                    if (nextComponent == null) {
                        if (version != ByteComparable.Version.LEGACY) {
                            return 62;
                        }
                        return ClusteringComparator.this.subtype(this.srcnum).isReversed() ? 65 : 63;
                    }
                    this.current = ClusteringComparator.this.subtype(this.srcnum).asComparableBytes(ByteComparableClustering.this.src.accessor(), nextComponent, version);
                    if (this.current == null) {
                        return ClusteringComparator.this.subtype(this.srcnum).isReversed() ? 65 : 63;
                    }
                    return 64;
                }
            };
        }

        public String toString() {
            return this.src.clusteringString(ClusteringComparator.this.subtypes());
        }
    }
}

