/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.guardrails;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.cassandra.db.guardrails.Guardrail;
import org.apache.cassandra.service.ClientState;

public class EnableFlag
extends Guardrail {
    private final Predicate<ClientState> warned;
    private final Predicate<ClientState> enabled;
    private final String featureName;

    public EnableFlag(String name, @Nullable String reason, Predicate<ClientState> enabled, String featureName) {
        this(name, reason, state -> false, enabled, featureName);
    }

    public EnableFlag(String name, @Nullable String reason, Predicate<ClientState> warned, Predicate<ClientState> enabled, String featureName) {
        super(name, reason);
        this.warned = warned;
        this.enabled = enabled;
        this.featureName = featureName;
    }

    public boolean isEnabled(@Nullable ClientState state) {
        return !this.enabled(state) || this.enabled.test(state);
    }

    public void ensureEnabled(@Nullable ClientState state) {
        this.ensureEnabled(this.featureName, state);
    }

    public void ensureEnabled(String featureName, @Nullable ClientState state) {
        if (!this.enabled(state)) {
            return;
        }
        if (!this.enabled.test(state)) {
            this.fail(featureName + " is not allowed", state);
            return;
        }
        if (this.warned.test(state)) {
            this.warn(featureName + " is not recommended");
        }
    }
}

