/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.lifecycle.LogRecord;
import org.apache.cassandra.db.lifecycle.LogTransaction;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.NativeLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LogReplica
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(LogReplica.class);
    private static final boolean REQUIRE_FD = !CassandraRelevantProperties.IGNORE_MISSING_NATIVE_FILE_HINTS.getBoolean();
    private final File file;
    private int directoryDescriptor;
    private final Map<String, String> errors = new HashMap<String, String>();

    static LogReplica create(File directory, String fileName) {
        int folderFD = NativeLibrary.tryOpenDirectory(directory.path());
        if (folderFD == -1 && REQUIRE_FD) {
            if (DatabaseDescriptor.isClientInitialized()) {
                logger.warn("Invalid folder descriptor trying to create log replica {}. Continuing without Native I/O support.", (Object)directory.path());
            } else {
                throw new FSReadError((Throwable)new IOException(String.format("Invalid folder descriptor trying to create log replica %s", directory.path())), directory.path());
            }
        }
        return new LogReplica(new File(fileName), folderFD);
    }

    static LogReplica open(File file) {
        int folderFD = NativeLibrary.tryOpenDirectory(file.parent().path());
        if (folderFD == -1) {
            if (DatabaseDescriptor.isClientInitialized()) {
                logger.warn("Invalid folder descriptor trying to create log replica {}. Continuing without Native I/O support.", (Object)file.parentPath());
            } else {
                throw new FSReadError((Throwable)new IOException(String.format("Invalid folder descriptor trying to create log replica %s", file.parent().path())), file.parent().path());
            }
        }
        return new LogReplica(file, folderFD);
    }

    LogReplica(File file, int directoryDescriptor) {
        this.file = file;
        this.directoryDescriptor = directoryDescriptor;
    }

    File file() {
        return this.file;
    }

    List<String> readLines() {
        return FileUtils.readLines(this.file);
    }

    String getFileName() {
        return this.file.name();
    }

    String getDirectory() {
        return this.file.parentPath();
    }

    void append(LogRecord record) {
        boolean existed = this.exists();
        try {
            FileUtils.appendAndSync(this.file, record.toString());
        }
        catch (FSError e) {
            logger.error("Failed to sync file {}", (Object)this.file, (Object)e);
            FileUtils.handleFSErrorAndPropagate(e);
        }
        if (!existed) {
            this.syncDirectory();
        }
    }

    void syncDirectory() {
        try {
            if (this.directoryDescriptor >= 0) {
                NativeLibrary.trySync(this.directoryDescriptor);
            }
        }
        catch (FSError e) {
            logger.error("Failed to sync directory descriptor {}", (Object)this.directoryDescriptor, (Object)e);
            FileUtils.handleFSErrorAndPropagate(e);
        }
    }

    void delete() {
        LogTransaction.delete(this.file);
        this.syncDirectory();
    }

    boolean exists() {
        return this.file.exists();
    }

    @Override
    public void close() {
        if (this.directoryDescriptor >= 0) {
            NativeLibrary.tryCloseFD(this.directoryDescriptor);
            this.directoryDescriptor = -1;
        }
    }

    public String toString() {
        return String.format("[%s] ", this.file);
    }

    void setError(String line, String error) {
        this.errors.put(line, error);
    }

    void printContentsWithAnyErrors(StringBuilder str) {
        str.append(this.file.path());
        str.append(System.lineSeparator());
        FileUtils.readLines(this.file).forEach(line -> this.printLineWithAnyError(str, (String)line));
    }

    private void printLineWithAnyError(StringBuilder str, String line) {
        str.append('\t');
        str.append(line);
        str.append(System.lineSeparator());
        String error = this.errors.get(line);
        if (error != null) {
            str.append("\t\t***");
            str.append(error);
            str.append(System.lineSeparator());
        }
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

