/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.metrics.CQLMetrics;
import org.apache.cassandra.schema.TableMetadata;

final class CQLMetricsTable
extends AbstractVirtualTable {
    public static final String TABLE_NAME = "cql_metrics";
    public static final String PREPARED_STATEMENTS_COUNT = "prepared_statements_count";
    public static final String PREPARED_STATEMENTS_EVICTED = "prepared_statements_evicted";
    public static final String PREPARED_STATEMENTS_EXECUTED = "prepared_statements_executed";
    public static final String PREPARED_STATEMENTS_RATIO = "prepared_statements_ratio";
    public static final String REGULAR_STATEMENTS_EXECUTED = "regular_statements_executed";
    public static final String NAME_COL = "name";
    public static final String VALUE_COL = "value";
    private final CQLMetrics cqlMetrics;

    CQLMetricsTable(String keyspace) {
        this(keyspace, QueryProcessor.metrics);
    }

    @VisibleForTesting
    CQLMetricsTable(String keyspace, CQLMetrics cqlMetrics) {
        super(TableMetadata.builder(keyspace, TABLE_NAME).comment("Metrics specific to CQL prepared statement caching").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(NAME_COL, UTF8Type.instance).addRegularColumn(VALUE_COL, DoubleType.instance).build());
        this.cqlMetrics = cqlMetrics;
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        this.addRow(result, PREPARED_STATEMENTS_COUNT, this.cqlMetrics.preparedStatementsCount.getValue().intValue());
        this.addRow(result, PREPARED_STATEMENTS_EVICTED, this.cqlMetrics.preparedStatementsEvicted.getCount());
        this.addRow(result, PREPARED_STATEMENTS_EXECUTED, this.cqlMetrics.preparedStatementsExecuted.getCount());
        this.addRow(result, PREPARED_STATEMENTS_RATIO, this.cqlMetrics.preparedStatementsRatio.getValue());
        this.addRow(result, REGULAR_STATEMENTS_EXECUTED, this.cqlMetrics.regularStatementsExecuted.getCount());
        return result;
    }

    private void addRow(SimpleDataSet dataSet, String name, double value) {
        dataSet.row(name).column(VALUE_COL, value);
    }
}

