/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bitpack;

import java.io.IOException;
import org.apache.cassandra.index.sai.disk.ResettableByteBuffersIndexOutput;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.packed.DirectWriter;

public abstract class AbstractBlockPackedWriter {
    static final int MIN_BLOCK_SIZE = 64;
    static final int MAX_BLOCK_SIZE = 0x8000000;
    protected final IndexOutput indexOutput;
    protected final long[] blockValues;
    protected final ResettableByteBuffersIndexOutput blockMetaWriter;
    protected int blockIndex;
    protected boolean finished;

    AbstractBlockPackedWriter(IndexOutput indexOutput, int blockSize) {
        SAICodecUtils.checkBlockSize(blockSize, 64, 0x8000000);
        this.indexOutput = indexOutput;
        this.blockMetaWriter = new ResettableByteBuffersIndexOutput(blockSize, "BlockPackedMeta");
        this.blockValues = new long[blockSize];
    }

    public void add(long l) throws IOException {
        this.checkNotFinished();
        if (this.blockIndex == this.blockValues.length) {
            this.flush();
        }
        this.blockValues[this.blockIndex++] = l;
    }

    public long finish() throws IOException {
        this.checkNotFinished();
        if (this.blockIndex > 0) {
            this.flush();
        }
        long fp = this.indexOutput.getFilePointer();
        this.blockMetaWriter.copyTo(this.indexOutput);
        this.finished = true;
        return fp;
    }

    protected abstract void flushBlock() throws IOException;

    void writeValues(int numValues, int bitsPerValue) throws IOException {
        DirectWriter writer = DirectWriter.getInstance(this.indexOutput, numValues, bitsPerValue);
        for (int i = 0; i < numValues; ++i) {
            writer.add(this.blockValues[i]);
        }
        writer.finish();
    }

    void writeVLong(IndexOutput out, long i) throws IOException {
        int k = 0;
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L && k++ < 8) {
            out.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        out.writeByte((byte)i);
    }

    private void flush() throws IOException {
        this.flushBlock();
        this.blockIndex = 0;
    }

    private void checkNotFinished() {
        if (this.finished) {
            throw new IllegalStateException(String.format("[%s] Writer already finished!", this.indexOutput.getName()));
        }
    }
}

