/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.memory;

import java.util.PriorityQueue;
import java.util.SortedSet;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.utils.PrimaryKey;

@NotThreadSafe
public class InMemoryKeyRangeIterator
extends KeyRangeIterator {
    private final PriorityQueue<PrimaryKey> keys;
    private final boolean uniqueKeys;
    private PrimaryKey lastKey;

    public InMemoryKeyRangeIterator(SortedSet<PrimaryKey> keys) {
        super(keys.first(), keys.last(), keys.size(), () -> {});
        this.keys = new PriorityQueue<PrimaryKey>(keys);
        this.uniqueKeys = true;
    }

    public InMemoryKeyRangeIterator(PrimaryKey min2, PrimaryKey max, PriorityQueue<PrimaryKey> keys) {
        super(min2, max, keys.size(), () -> {});
        this.keys = keys;
        this.uniqueKeys = false;
    }

    @Override
    protected PrimaryKey computeNext() {
        PrimaryKey key = this.computeNextKey();
        return key == null ? (PrimaryKey)this.endOfData() : key;
    }

    protected PrimaryKey computeNextKey() {
        PrimaryKey next = null;
        while (!this.keys.isEmpty()) {
            PrimaryKey key = this.keys.poll();
            if (this.uniqueKeys) {
                return key;
            }
            if (this.lastKey != null && this.lastKey.compareTo(key, false) == 0) continue;
            next = key;
            this.lastKey = key;
            break;
        }
        return next;
    }

    @Override
    protected void performSkipTo(PrimaryKey nextKey) {
        PrimaryKey key;
        while (!this.keys.isEmpty() && (key = this.keys.peek()).compareTo(nextKey, false) < 0) {
            this.keys.poll();
        }
    }

    @Override
    public void close() {
    }
}

