/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.chunked;

final class Util {
    static final int CHUNK_OFF_TIMESTAMP = 0;
    static final int CHUNK_OFF_ENTRIES = 8;
    static final int CHUNK_OFF_BYTES = 12;
    static final int CHUNK_OFF_DATA = 16;
    static final int ENTRY_OFF_HASH = 0;
    static final int ENTRY_OFF_NEXT = 8;
    static final int ENTRY_OFF_REMOVED = 12;
    static final int ENTRY_OFF_DATA_FIXED = 16;
    static final int ENTRY_OFF_VALUE_LENGTH = 12;
    static final int ENTRY_OFF_KEY_LENGTH = 16;
    static final int ENTRY_OFF_RESERVED_LENGTH = 20;
    static final int ENTRY_OFF_DATA_VARIABLE = 24;

    Util() {
    }

    static int allocLen(int keyLen, int valueLen, boolean fixedEntrySize) {
        return Util.entryOffData(fixedEntrySize) + keyLen + valueLen;
    }

    static int entryOffData(boolean fixedEntrySize) {
        return fixedEntrySize ? 16 : 24;
    }

    static int bitNum(long val) {
        int bit = 0;
        while (val != 0L) {
            val >>>= 1;
            ++bit;
        }
        return bit;
    }

    static long roundUpToPowerOf2(long number, long max) {
        return number >= max ? max : (number > 1L ? Long.highestOneBit(number - 1L << 1) : 1L);
    }
}

