/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.util.Map;
import java.util.Properties;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.lab.jvm.attach.AttachManager;
import org.gridkit.lab.jvm.attach.JavaProcessDetails;
import org.gridkit.lab.jvm.perfdata.JStatData;

public class VmInfoCmd
implements CommandLauncher.CmdRef {
    @Override
    public String getCommandName() {
        return "vminfo";
    }

    @Override
    public Runnable newCommand(CommandLauncher host) {
        return new VmInfo(host);
    }

    @Parameters(commandDescription="[VMINFO] Dumps various from local VM")
    public static class VmInfo
    implements Runnable {
        @ParametersDelegate
        private final CommandLauncher host;
        @Parameter(names={"--flags"}, required=false, description="Dump XX flags")
        private boolean dumpVmFlags = false;
        @Parameter(names={"--sysprops"}, required=false, description="Dump System.getProperties()")
        private boolean dumpSysProps = false;
        @Parameter(names={"--agentprops"}, required=false, description="Dump agent properties")
        private boolean dumpAgentProps = false;
        @Parameter(names={"--perf"}, required=false, description="Dump perf counters")
        private boolean dumpPerfCounters = false;
        @Parameter(names={"-p"}, required=true, description="Target JVM PID")
        private String pid;

        public VmInfo(CommandLauncher host) {
            this.host = host;
        }

        @Override
        public void run() {
            if (!(this.dumpVmFlags | this.dumpSysProps | this.dumpAgentProps | this.dumpPerfCounters)) {
                this.host.failAndPrintUsage("No dump option specified");
            }
            JavaProcessDetails jpd = AttachManager.getDetails(Long.parseLong(this.pid));
            if (this.dumpVmFlags) {
                StringBuilder sb = new StringBuilder();
                jpd.jcmd("VM.flags -all", sb);
                System.out.println(sb);
            }
            if (this.dumpSysProps) {
                this.dumpProps(jpd.getSystemProperties());
            }
            if (this.dumpAgentProps) {
                this.dumpProps(jpd.getAgentProperties());
            }
            if (this.dumpPerfCounters) {
                JStatData jsd = JStatData.connect(Long.parseLong(this.pid));
                this.dumpPerf(jsd.getAllCounters());
            }
        }

        private void dumpPerf(Map<String, JStatData.Counter<?>> allCounters) {
            for (String key : allCounters.keySet()) {
                JStatData.Counter<?> c = allCounters.get(key);
                if (c instanceof JStatData.TickCounter) {
                    String val = c.toString();
                    String suffix = "";
                    if (val.lastIndexOf(91) >= 0) {
                        suffix = " " + val.substring(val.lastIndexOf(91));
                    }
                    System.out.println(key + ": " + ((JStatData.TickCounter)c).getNanos() + " ns" + suffix);
                    continue;
                }
                System.out.println(allCounters.get(key));
            }
        }

        private void dumpProps(Properties systemProperties) {
            for (Object k : systemProperties.keySet()) {
                String key = (String)k;
                System.out.println(key + ": " + systemProperties.getProperty(key));
            }
        }
    }
}

