/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.spark.config.SchemaFeature;
import org.apache.cassandra.spark.config.SchemaFeatureSet;
import org.apache.cassandra.spark.data.BasicSupplier;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.DataLayer;
import org.apache.cassandra.spark.data.FileSystemSSTable;
import org.apache.cassandra.spark.data.FileSystemSource;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.SSTablesSupplier;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.sparksql.filters.PartitionKeyFilter;
import org.apache.cassandra.spark.sparksql.filters.SparkRangeFilter;
import org.apache.cassandra.spark.utils.Throwing;
import org.apache.cassandra.spark.utils.TimeProvider;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.parquet.Strings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalDataLayer
extends DataLayer
implements Serializable {
    public static final long serialVersionUID = 42L;
    private transient CassandraBridge bridge;
    private Partitioner partitioner;
    private CqlTable cqlTable;
    private String jobId;
    private String statsClass;
    private volatile transient Stats stats = null;
    private List<SchemaFeature> requestedFeatures;
    private boolean useBufferingInputStream;
    private String[] paths;
    private int minimumReplicasPerMutation = 1;
    private Set<Path> dataFilePaths = null;

    @Nullable
    private static Stats loadStats(@Nullable String statsClass) {
        if (Strings.isNullOrEmpty((String)statsClass)) {
            return null;
        }
        try {
            int index = statsClass.lastIndexOf(".");
            String className = statsClass.substring(0, index);
            String fieldName = statsClass.substring(index + 1);
            Field field = Class.forName(className).getDeclaredField(fieldName);
            return (Stats)field.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Nullable
    private static String lowerCaseKey(@Nullable String key) {
        return key != null ? key.toLowerCase(Locale.ROOT) : null;
    }

    @NotNull
    private static String getOrThrow(@NotNull Map<String, String> options, @Nullable String key) {
        String value = options.get(key);
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException("Value for key '" + key + "' is missing from the options map");
    }

    private static boolean getBoolean(@NotNull Map<String, String> options, @Nullable String key, boolean defaultValue) {
        String value = options.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("Value '" + value + "' for key '" + key + "' is not a boolean string");
    }

    public static LocalDataLayer from(Map<String, String> options) {
        return new LocalDataLayer(CassandraVersion.valueOf((String)options.getOrDefault(LocalDataLayer.lowerCaseKey("version"), CassandraVersion.FOURZERO.name())), Partitioner.valueOf((String)options.getOrDefault(LocalDataLayer.lowerCaseKey("partitioner"), Partitioner.Murmur3Partitioner.name())), LocalDataLayer.getOrThrow(options, LocalDataLayer.lowerCaseKey("keyspace")), LocalDataLayer.getOrThrow(options, LocalDataLayer.lowerCaseKey("createStmt")), Arrays.stream(options.getOrDefault(LocalDataLayer.lowerCaseKey("udts"), "").split("\n")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet()), SchemaFeatureSet.initializeFromOptions(options), LocalDataLayer.getBoolean(options, LocalDataLayer.lowerCaseKey("useBufferingInputStream"), LocalDataLayer.getBoolean(options, LocalDataLayer.lowerCaseKey("useSSTableInputStream"), false)), options.get(LocalDataLayer.lowerCaseKey("statsClass")), LocalDataLayer.getOrThrow(options, LocalDataLayer.lowerCaseKey("dirs")).split(","));
    }

    public LocalDataLayer(@NotNull CassandraVersion version, @NotNull String keyspace, @NotNull String createStatement, String ... paths) {
        this(version, Partitioner.Murmur3Partitioner, keyspace, createStatement, Collections.emptySet(), Collections.emptyList(), false, null, paths);
    }

    public LocalDataLayer(@NotNull CassandraVersion version, @NotNull String keyspace, @NotNull String createStatement, @NotNull Set<String> udtStatements, String ... paths) {
        this(version, Partitioner.Murmur3Partitioner, keyspace, createStatement, udtStatements, Collections.emptyList(), false, null, paths);
    }

    public LocalDataLayer(@NotNull CassandraVersion version, @NotNull Partitioner partitioner, @NotNull String keyspace, @NotNull String createStatement, @NotNull Set<String> udts, @NotNull List<SchemaFeature> requestedFeatures, boolean useBufferingInputStream, @Nullable String statsClass, String ... paths) {
        this.bridge = CassandraBridgeFactory.get(version);
        this.partitioner = partitioner;
        this.cqlTable = this.bridge().buildSchema(createStatement, keyspace, new ReplicationFactor(ReplicationFactor.ReplicationStrategy.SimpleStrategy, (Map)ImmutableMap.of((Object)"replication_factor", (Object)1)), partitioner, udts);
        this.jobId = UUID.randomUUID().toString();
        this.requestedFeatures = requestedFeatures;
        this.useBufferingInputStream = useBufferingInputStream;
        this.statsClass = statsClass;
        this.paths = paths;
        this.dataFilePaths = new HashSet<Path>();
    }

    private LocalDataLayer(@NotNull CassandraVersion version, @NotNull Partitioner partitioner, @NotNull CqlTable cqlTable, @NotNull String jobId, @NotNull List<SchemaFeature> requestedFeatures, boolean useBufferingInputStream, @Nullable String statsClass, String ... paths) {
        this.bridge = CassandraBridgeFactory.get(version);
        this.partitioner = partitioner;
        this.cqlTable = cqlTable;
        this.jobId = jobId;
        this.requestedFeatures = requestedFeatures;
        this.useBufferingInputStream = useBufferingInputStream;
        this.statsClass = statsClass;
        this.paths = paths;
    }

    @Override
    public List<SchemaFeature> requestedFeatures() {
        return this.requestedFeatures;
    }

    @Override
    public CassandraBridge bridge() {
        return this.bridge;
    }

    @Override
    public Partitioner partitioner() {
        return this.partitioner;
    }

    @Override
    public int partitionCount() {
        return 1;
    }

    @Override
    public boolean isInPartition(int partitionId, BigInteger token, ByteBuffer key) {
        return true;
    }

    @Override
    public TimeProvider timeProvider() {
        return TimeProvider.DEFAULT;
    }

    @Override
    public CqlTable cqlTable() {
        return this.cqlTable;
    }

    @Override
    public synchronized Stats stats() {
        if (this.stats == null) {
            this.stats = LocalDataLayer.loadStats(this.statsClass);
        }
        if (this.stats == null) {
            this.stats = super.stats();
        }
        return this.stats;
    }

    public void setDataFilePaths(Set<Path> dataFilePaths) {
        this.dataFilePaths = dataFilePaths;
    }

    @Override
    public SSTablesSupplier sstables(int partitionId, @Nullable SparkRangeFilter sparkRangeFilter, @NotNull List<PartitionKeyFilter> partitionKeyFilters) {
        Stream<Object> dataFilePathsStream = this.dataFilePaths != null && !this.dataFilePaths.isEmpty() ? this.dataFilePaths.stream() : Arrays.stream(this.paths).map(x$0 -> Paths.get(x$0, new String[0])).flatMap(Throwing.function(Files::list)).filter(path -> path.getFileName().toString().endsWith("-" + FileType.DATA.getFileSuffix()));
        return new BasicSupplier(dataFilePathsStream.map(path -> new FileSystemSSTable(path, this.useBufferingInputStream, () -> this.stats.bufferingInputStreamStats())).collect(Collectors.toSet()));
    }

    @VisibleForTesting
    public LocalDataLayer withMinimumReplicasPerMutation(int minimumReplicasPerMutation) {
        this.minimumReplicasPerMutation = minimumReplicasPerMutation;
        return this;
    }

    @Override
    public String jobId() {
        return this.jobId;
    }

    @Override
    protected ExecutorService executorService() {
        return FileSystemSource.FILE_IO_EXECUTOR;
    }

    private static Stream<Path> listPath(Path path) {
        try {
            return Files.list(path);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.cqlTable).append((Object[])this.paths).append((Object)this.version()).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        LocalDataLayer that = (LocalDataLayer)other;
        return new EqualsBuilder().append((Object)this.cqlTable, (Object)that.cqlTable).append((Object[])this.paths, (Object[])that.paths).append((Object)this.version(), (Object)that.version()).isEquals();
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.writeUTF(this.version().name());
        out.writeObject(this.partitioner);
        this.bridge.javaSerialize(out, (Serializable)this.cqlTable);
        out.writeUTF(this.jobId);
        out.writeObject(this.requestedFeatures.stream().map(Object::toString).toArray(String[]::new));
        out.writeBoolean(this.useBufferingInputStream);
        out.writeBoolean(this.statsClass != null);
        if (this.statsClass != null) {
            out.writeUTF(this.statsClass);
        }
        out.writeObject(this.paths);
        out.writeInt(this.minimumReplicasPerMutation);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.bridge = CassandraBridgeFactory.get(CassandraVersion.valueOf((String)in.readUTF()));
        this.partitioner = (Partitioner)in.readObject();
        this.cqlTable = (CqlTable)this.bridge.javaDeserialize(in, CqlTable.class);
        this.jobId = in.readUTF();
        this.requestedFeatures = Arrays.stream((String[])in.readObject()).map(SchemaFeatureSet::valueOf).collect(Collectors.toList());
        this.useBufferingInputStream = in.readBoolean();
        this.statsClass = in.readBoolean() ? in.readUTF() : null;
        this.paths = (String[])in.readObject();
        this.minimumReplicasPerMutation = in.readInt();
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<LocalDataLayer> {
        public void write(Kryo kryo, Output out, LocalDataLayer object) {
            kryo.writeObject(out, (Object)object.version());
            kryo.writeObject(out, (Object)object.partitioner);
            kryo.writeObject(out, (Object)object.cqlTable);
            out.writeString(object.jobId);
            kryo.writeObject(out, object.requestedFeatures.stream().map(Object::toString).toArray(String[]::new));
            out.writeBoolean(object.useBufferingInputStream);
            out.writeString(object.statsClass);
            kryo.writeObject(out, (Object)object.paths);
            out.writeInt(object.minimumReplicasPerMutation);
        }

        public LocalDataLayer read(Kryo kryo, Input in, Class<LocalDataLayer> type) {
            return new LocalDataLayer((CassandraVersion)kryo.readObject(in, CassandraVersion.class), (Partitioner)kryo.readObject(in, Partitioner.class), (CqlTable)kryo.readObject(in, CqlTable.class), in.readString(), Arrays.stream((String[])kryo.readObject(in, String[].class)).map(SchemaFeatureSet::valueOf).collect(Collectors.toList()), in.readBoolean(), in.readString(), (String[])kryo.readObject(in, String[].class)).withMinimumReplicasPerMutation(in.readInt());
        }
    }
}

