/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.transports.storage;

import java.util.Objects;
import o.a.c.sidecar.client.shaded.common.data.RestoreJobSecrets;
import org.apache.cassandra.spark.transports.storage.StorageCredentials;

public class StorageCredentialPair {
    private final String writeRegion;
    public final StorageCredentials writeCredentials;
    private final String readRegion;
    public final StorageCredentials readCredentials;

    public StorageCredentialPair(String writeRegion, StorageCredentials writeCredentials, String readRegion, StorageCredentials readCredentials) {
        this.writeRegion = writeRegion;
        this.writeCredentials = writeCredentials;
        this.readRegion = readRegion;
        this.readCredentials = readCredentials;
    }

    public RestoreJobSecrets toRestoreJobSecrets() {
        return new RestoreJobSecrets(this.readCredentials.toSidecarCredentials(this.readRegion), this.writeCredentials.toSidecarCredentials(this.writeRegion));
    }

    public String toString() {
        return "StorageCredentialPair{writeRegion=" + this.writeRegion + ", writeCredentials=" + String.valueOf(this.writeCredentials) + ", readRegion=" + this.readRegion + ", readCredentials=" + String.valueOf(this.readCredentials) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StorageCredentialPair)) {
            return false;
        }
        StorageCredentialPair that = (StorageCredentialPair)o;
        return Objects.equals(this.writeRegion, that.writeRegion) && Objects.equals(this.writeCredentials, that.writeCredentials) && Objects.equals(this.readRegion, that.readRegion) && Objects.equals(this.readCredentials, that.readCredentials);
    }

    public int hashCode() {
        return Objects.hash(this.writeRegion, this.writeCredentials, this.readRegion, this.readCredentials);
    }
}

