/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.api;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.cdc.api.CommitLog;
import org.apache.cassandra.cdc.api.Marker;
import org.apache.cassandra.cdc.api.PerInstanceCommitLogMarkers;
import org.apache.cassandra.cdc.api.PerRangeCommitLogMarkers;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CommitLogMarkers
extends Serializable {
    public static final PerInstanceCommitLogMarkers EMPTY = new PerInstanceCommitLogMarkers((Map<CassandraInstance, Marker>)ImmutableMap.of());
    public static final Serializer SERIALIZER = new Serializer();

    @NotNull
    default public Marker startMarker(CommitLog log) {
        return this.startMarker(log.instance());
    }

    @NotNull
    public Marker startMarker(CassandraInstance var1);

    public boolean canIgnore(Marker var1, BigInteger var2);

    public static PerInstanceCommitLogMarkers of(@Nullable Marker marker) {
        if (marker == null) {
            return EMPTY;
        }
        return CommitLogMarkers.of((Map<CassandraInstance, Marker>)ImmutableMap.of((Object)marker.instance(), (Object)marker));
    }

    public static PerInstanceCommitLogMarkers of(Map<CassandraInstance, Marker> markers) {
        return new PerInstanceCommitLogMarkers(markers);
    }

    public static PerInstanceCommitLogMarkers of(CommitLogMarkers markers1, CommitLogMarkers markers2) {
        return new PerInstanceCommitLogMarkers(markers1.values(), markers2.values());
    }

    public boolean isEmpty();

    public Collection<Marker> values();

    public PerInstanceCommitLogMarkers.PerInstanceBuilder mutate();

    public static PerInstanceCommitLogMarkers.PerInstanceBuilder perInstanceBuilder() {
        return new PerInstanceCommitLogMarkers.PerInstanceBuilder();
    }

    public static PerRangeCommitLogMarkers.PerRangeBuilder perRangeBuilder() {
        return new PerRangeCommitLogMarkers.PerRangeBuilder();
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<CommitLogMarkers> {
        public CommitLogMarkers read(Kryo kryo, Input in, Class type) {
            int size = in.readShort();
            HashMap<CassandraInstance, Marker> markers = new HashMap<CassandraInstance, Marker>(size);
            for (int i = 0; i < size; ++i) {
                Marker marker = (Marker)kryo.readObject(in, Marker.class, (com.esotericsoftware.kryo.Serializer)Marker.SERIALIZER);
                markers.put(marker.instance(), marker);
            }
            return new PerInstanceCommitLogMarkers(markers);
        }

        public void write(Kryo kryo, Output out, CommitLogMarkers markers) {
            Collection<Marker> allMarkers = markers.values();
            out.writeShort(allMarkers.size());
            for (Marker marker : allMarkers) {
                kryo.writeObject(out, (Object)marker, (com.esotericsoftware.kryo.Serializer)Marker.SERIALIZER);
            }
        }
    }
}

