/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.DisallowedDirectories;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.service.StorageService;

public class DiskBoundaries {
    public final List<Directories.DataDirectory> directories;
    public final ImmutableList<PartitionPosition> positions;
    final long ringVersion;
    final int directoriesVersion;
    private final ColumnFamilyStore cfs;
    private volatile boolean isInvalid = false;

    public DiskBoundaries(ColumnFamilyStore cfs, Directories.DataDirectory[] directories, int diskVersion) {
        this(cfs, directories, null, -1L, diskVersion);
    }

    @VisibleForTesting
    public DiskBoundaries(ColumnFamilyStore cfs, Directories.DataDirectory[] directories, List<PartitionPosition> positions, long ringVersion, int diskVersion) {
        this.directories = directories == null ? null : ImmutableList.copyOf(directories);
        this.positions = positions == null ? null : ImmutableList.copyOf(positions);
        this.ringVersion = ringVersion;
        this.directoriesVersion = diskVersion;
        this.cfs = cfs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiskBoundaries that = (DiskBoundaries)o;
        if (this.ringVersion != that.ringVersion) {
            return false;
        }
        if (this.directoriesVersion != that.directoriesVersion) {
            return false;
        }
        if (!this.directories.equals(that.directories)) {
            return false;
        }
        return this.positions != null ? this.positions.equals(that.positions) : that.positions == null;
    }

    public int hashCode() {
        int result = this.directories != null ? this.directories.hashCode() : 0;
        result = 31 * result + (this.positions != null ? this.positions.hashCode() : 0);
        result = 31 * result + (int)(this.ringVersion ^ this.ringVersion >>> 32);
        result = 31 * result + this.directoriesVersion;
        return result;
    }

    public String toString() {
        return "DiskBoundaries{directories=" + this.directories + ", positions=" + this.positions + ", ringVersion=" + this.ringVersion + ", directoriesVersion=" + this.directoriesVersion + '}';
    }

    public boolean isOutOfDate() {
        if (this.isInvalid) {
            return true;
        }
        int currentDiskVersion = DisallowedDirectories.getDirectoriesVersion();
        long currentRingVersion = StorageService.instance.getTokenMetadata().getRingVersion();
        return currentDiskVersion != this.directoriesVersion || this.ringVersion != -1L && currentRingVersion != this.ringVersion;
    }

    public void invalidate() {
        this.isInvalid = true;
    }

    public int getDiskIndex(SSTableReader sstable) {
        if (this.positions == null) {
            return this.getBoundariesFromSSTableDirectory(sstable.descriptor);
        }
        int pos = Collections.binarySearch(this.positions, sstable.first);
        assert (pos < 0);
        return -pos - 1;
    }

    public int getBoundariesFromSSTableDirectory(Descriptor descriptor) {
        Directories.DataDirectory actualDirectory = this.cfs.getDirectories().getDataDirectoryForFile(descriptor);
        for (int i = 0; i < this.directories.size(); ++i) {
            Directories.DataDirectory directory = this.directories.get(i);
            if (actualDirectory == null || !actualDirectory.equals(directory)) continue;
            return i;
        }
        return 0;
    }

    public Directories.DataDirectory getCorrectDiskForSSTable(SSTableReader sstable) {
        return this.directories.get(this.getDiskIndex(sstable));
    }

    public Directories.DataDirectory getCorrectDiskForKey(DecoratedKey key) {
        if (this.positions == null) {
            return null;
        }
        return this.directories.get(this.getDiskIndex(key));
    }

    public boolean isInCorrectLocation(SSTableReader sstable, Directories.DataDirectory currentLocation) {
        int diskIndex = this.getDiskIndex(sstable);
        PartitionPosition diskLast = (PartitionPosition)this.positions.get(diskIndex);
        return this.directories.get(diskIndex).equals(currentLocation) && sstable.last.compareTo(diskLast) <= 0;
    }

    private int getDiskIndex(DecoratedKey key) {
        int pos = Collections.binarySearch(this.positions, key);
        assert (pos < 0);
        return -pos - 1;
    }
}

