/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringBoundary;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;

public interface ValueAccessor<V> {
    public int size(V var1);

    default public int sizeWithVIntLength(V value) {
        int size = this.size(value);
        return TypeSizes.sizeofUnsignedVInt(size) + size;
    }

    default public int sizeWithShortLength(V value) {
        return 2 + this.size(value);
    }

    default public boolean isEmpty(V value) {
        return this.size(value) == 0;
    }

    default public int sizeFromOffset(V value, int offset) {
        return this.size(value) - offset;
    }

    default public boolean isEmptyFromOffset(V value, int offset) {
        return this.sizeFromOffset(value, offset) == 0;
    }

    public V[] createArray(int var1);

    public void write(V var1, DataOutputPlus var2) throws IOException;

    default public void writeWithVIntLength(V value, DataOutputPlus out) throws IOException {
        out.writeUnsignedVInt(this.size(value));
        this.write(value, out);
    }

    public void write(V var1, ByteBuffer var2);

    public <V2> int copyTo(V var1, int var2, V2 var3, ValueAccessor<V2> var4, int var5, int var6);

    public int copyByteArrayTo(byte[] var1, int var2, V var3, int var4, int var5);

    public int copyByteBufferTo(ByteBuffer var1, int var2, V var3, int var4, int var5);

    public void digest(V var1, int var2, int var3, Digest var4);

    default public void digest(V value, Digest digest) {
        this.digest(value, 0, this.size(value), digest);
    }

    public V read(DataInputPlus var1, int var2) throws IOException;

    public V slice(V var1, int var2, int var3);

    default public V sliceWithShortLength(V input, int offset) {
        int size = this.getUnsignedShort(input, offset);
        return this.slice(input, offset + 2, size);
    }

    public <VR> int compare(V var1, VR var2, ValueAccessor<VR> var3);

    public int compareByteArrayTo(byte[] var1, V var2);

    public int compareByteBufferTo(ByteBuffer var1, V var2);

    default public int hashCode(V value) {
        if (value == null) {
            return 0;
        }
        int result = 1;
        int isize = this.size(value);
        for (int i = 0; i < isize; ++i) {
            result = 31 * result + this.getByte(value, i);
        }
        return result;
    }

    public ByteBuffer toBuffer(V var1);

    public byte[] toArray(V var1);

    public byte[] toArray(V var1, int var2, int var3);

    public String toString(V var1, Charset var2) throws CharacterCodingException;

    default public String toString(V value) throws CharacterCodingException {
        return this.toString(value, StandardCharsets.UTF_8);
    }

    public String toHex(V var1);

    default public boolean getBoolean(V value, int offset) {
        return this.getByte(value, offset) != 0;
    }

    public byte toByte(V var1);

    public byte getByte(V var1, int var2);

    public short toShort(V var1);

    public short getShort(V var1, int var2);

    public int getUnsignedShort(V var1, int var2);

    public int toInt(V var1);

    public int getInt(V var1, int var2);

    public long toLong(V var1);

    public long getLong(V var1, int var2);

    public float toFloat(V var1);

    public double toDouble(V var1);

    public UUID toUUID(V var1);

    public int putByte(V var1, int var2, byte var3);

    public int putShort(V var1, int var2, short var3);

    public int putInt(V var1, int var2, int var3);

    public int putLong(V var1, int var2, long var3);

    public V empty();

    public V valueOf(byte[] var1);

    public V valueOf(ByteBuffer var1);

    public V valueOf(String var1, Charset var2);

    public V valueOf(UUID var1);

    public V valueOf(boolean var1);

    public V valueOf(byte var1);

    public V valueOf(short var1);

    public V valueOf(int var1);

    public V valueOf(long var1);

    public V valueOf(float var1);

    public V valueOf(double var1);

    public <V2> V convert(V2 var1, ValueAccessor<V2> var2);

    public V allocate(int var1);

    public ObjectFactory<V> factory();

    public static <L, R> int compare(L left, ValueAccessor<L> leftAccessor, R right, ValueAccessor<R> rightAccessor) {
        return leftAccessor.compare(left, right, rightAccessor);
    }

    public static <L, R> boolean equals(L left, ValueAccessor<L> leftAccessor, R right, ValueAccessor<R> rightAccessor) {
        return ValueAccessor.compare(left, leftAccessor, right, rightAccessor) == 0;
    }

    public static interface ObjectFactory<V> {
        public Cell<V> cell(ColumnMetadata var1, long var2, int var4, int var5, V var6, CellPath var7);

        public Clustering<V> clustering(V ... var1);

        public Clustering<V> clustering();

        public ClusteringBound<V> bound(ClusteringPrefix.Kind var1, V ... var2);

        public ClusteringBound<V> bound(ClusteringPrefix.Kind var1);

        public ClusteringBoundary<V> boundary(ClusteringPrefix.Kind var1, V ... var2);

        default public ClusteringBoundOrBoundary<V> boundOrBoundary(ClusteringPrefix.Kind kind, V ... values) {
            return kind.isBoundary() ? this.boundary(kind, values) : this.bound(kind, values);
        }

        default public ClusteringBound<V> inclusiveOpen(boolean reversed, V[] boundValues) {
            return this.bound(reversed ? ClusteringPrefix.Kind.INCL_END_BOUND : ClusteringPrefix.Kind.INCL_START_BOUND, boundValues);
        }

        default public ClusteringBound<V> exclusiveOpen(boolean reversed, V[] boundValues) {
            return this.bound(reversed ? ClusteringPrefix.Kind.EXCL_END_BOUND : ClusteringPrefix.Kind.EXCL_START_BOUND, boundValues);
        }

        default public ClusteringBound<V> inclusiveClose(boolean reversed, V[] boundValues) {
            return this.bound(reversed ? ClusteringPrefix.Kind.INCL_START_BOUND : ClusteringPrefix.Kind.INCL_END_BOUND, boundValues);
        }

        default public ClusteringBound<V> exclusiveClose(boolean reversed, V[] boundValues) {
            return this.bound(reversed ? ClusteringPrefix.Kind.EXCL_START_BOUND : ClusteringPrefix.Kind.EXCL_END_BOUND, boundValues);
        }

        default public ClusteringBoundary<V> inclusiveCloseExclusiveOpen(boolean reversed, V[] boundValues) {
            return this.boundary(reversed ? ClusteringPrefix.Kind.EXCL_END_INCL_START_BOUNDARY : ClusteringPrefix.Kind.INCL_END_EXCL_START_BOUNDARY, boundValues);
        }

        default public ClusteringBoundary<V> exclusiveCloseInclusiveOpen(boolean reversed, V[] boundValues) {
            return this.boundary(reversed ? ClusteringPrefix.Kind.INCL_END_EXCL_START_BOUNDARY : ClusteringPrefix.Kind.EXCL_END_INCL_START_BOUNDARY, boundValues);
        }
    }
}

