/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicaCollection;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;

public class EndpointsForRange
extends Endpoints<EndpointsForRange> {
    private final Range<Token> range;

    private EndpointsForRange(Range<Token> range, AbstractReplicaCollection.ReplicaList list, AbstractReplicaCollection.ReplicaMap<InetAddressAndPort> byEndpoint) {
        super(list, byEndpoint);
        this.range = range;
        assert (range != null);
    }

    public Range<Token> range() {
        return this.range;
    }

    public Builder newBuilder(int initialCapacity) {
        return new Builder(this.range, initialCapacity);
    }

    public EndpointsForToken forToken(Token token) {
        if (!this.range.contains(token)) {
            throw new IllegalArgumentException(token + " is not contained within " + this.range);
        }
        return new EndpointsForToken(token, this.list, this.byEndpoint);
    }

    @Override
    public EndpointsForRange snapshot() {
        return this;
    }

    @Override
    EndpointsForRange snapshot(AbstractReplicaCollection.ReplicaList newList) {
        if (newList.isEmpty()) {
            return EndpointsForRange.empty(this.range);
        }
        AbstractReplicaCollection.ReplicaMap byEndpoint = null;
        if (this.byEndpoint != null && this.list.isSubList(newList)) {
            byEndpoint = this.byEndpoint.forSubList(newList);
        }
        return new EndpointsForRange(this.range, newList, byEndpoint);
    }

    public static Builder builder(Range<Token> range) {
        return new Builder(range);
    }

    public static Builder builder(Range<Token> range, int capacity) {
        return new Builder(range, capacity);
    }

    public static EndpointsForRange empty(Range<Token> range) {
        return new EndpointsForRange(range, EMPTY_LIST, EMPTY_MAP);
    }

    public static EndpointsForRange of(Replica replica) {
        AbstractReplicaCollection.ReplicaList one = new AbstractReplicaCollection.ReplicaList(1);
        one.add(replica);
        return new EndpointsForRange(replica.range(), one, EndpointsForRange.endpointMap(one));
    }

    public static EndpointsForRange of(Replica ... replicas) {
        return EndpointsForRange.copyOf(Arrays.asList(replicas));
    }

    public static EndpointsForRange copyOf(Collection<Replica> replicas) {
        if (replicas.isEmpty()) {
            throw new IllegalArgumentException("Collection must be non-empty to copy");
        }
        Range<Token> range = replicas.iterator().next().range();
        assert (Iterables.all(replicas, r -> range.equals(r.range())));
        return (EndpointsForRange)EndpointsForRange.builder(range, replicas.size()).addAll(replicas).build();
    }

    public static class Builder
    extends EndpointsForRange
    implements ReplicaCollection.Builder<EndpointsForRange> {
        boolean built;

        public Builder(Range<Token> range) {
            this(range, 0);
        }

        public Builder(Range<Token> range, int capacity) {
            this(range, new AbstractReplicaCollection.ReplicaList(capacity));
        }

        private Builder(Range<Token> range, AbstractReplicaCollection.ReplicaList list) {
            super(range, list, Builder.endpointMap(list));
        }

        public Builder add(Replica replica, ReplicaCollection.Builder.Conflict ignoreConflict) {
            if (this.built) {
                throw new IllegalStateException();
            }
            Preconditions.checkNotNull(replica);
            if (!replica.range().contains((Token)((Object)((EndpointsForRange)this).range))) {
                throw new IllegalArgumentException("Replica " + replica + " does not contain " + ((EndpointsForRange)this).range);
            }
            if (!this.byEndpoint.internalPutIfAbsent(replica, this.list.size())) {
                switch (ignoreConflict) {
                    case DUPLICATE: {
                        if (this.byEndpoint().get(replica.endpoint()).equals(replica)) break;
                    }
                    case NONE: {
                        throw new IllegalArgumentException("Conflicting replica added (expected unique endpoints): " + replica + "; existing: " + this.byEndpoint().get(replica.endpoint()));
                    }
                }
                return this;
            }
            this.list.add(replica);
            return this;
        }

        @Override
        public EndpointsForRange snapshot() {
            return this.snapshot(this.list.subList(0, this.list.size()));
        }

        @Override
        public EndpointsForRange build() {
            this.built = true;
            return new EndpointsForRange(((EndpointsForRange)this).range, this.list, this.byEndpoint);
        }
    }
}

