/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.annotations.VisibleForTesting;
import io.netty.util.concurrent.ImmediateEventExecutor;
import org.apache.cassandra.net.AsyncPromise;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.RequestCallback;

public class AsyncOneResponse<T>
extends AsyncPromise<T>
implements RequestCallback<T> {
    public AsyncOneResponse() {
        super(ImmediateEventExecutor.INSTANCE);
    }

    @Override
    public void onResponse(Message<T> response) {
        this.setSuccess(response.payload);
    }

    @VisibleForTesting
    public static <T> AsyncOneResponse<T> immediate(T value) {
        AsyncOneResponse<T> response = new AsyncOneResponse<T>();
        response.setSuccess(value);
        return response;
    }
}

