/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.NativeLibrary;

public class UUIDGen {
    private static final long START_EPOCH = -12219292800000L;
    private static final long clockSeqAndNode = UUIDGen.makeClockSeqAndNode();
    public static final int UUID_LEN = 16;
    private static final long MIN_CLOCK_SEQ_AND_NODE = -9187201950435737472L;
    private static final long MAX_CLOCK_SEQ_AND_NODE = 0x7F7F7F7F7F7F7F7FL;
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final UUIDGen instance = new UUIDGen();
    private AtomicLong lastNanos = new AtomicLong();

    private UUIDGen() {
        if (clockSeqAndNode == 0L) {
            throw new RuntimeException("singleton instantiation is misplaced.");
        }
    }

    public static UUID getTimeUUID() {
        return new UUID(instance.createTimeSafe(), clockSeqAndNode);
    }

    public static UUID getTimeUUID(long when) {
        return new UUID(UUIDGen.createTime(UUIDGen.fromUnixTimestamp(when)), clockSeqAndNode);
    }

    public static UUID getTimeUUIDFromMicros(long whenInMicros) {
        long whenInMillis = whenInMicros / 1000L;
        long nanos = (whenInMicros - whenInMillis * 1000L) * 10L;
        return UUIDGen.getTimeUUID(whenInMillis, nanos);
    }

    public static UUID getRandomTimeUUIDFromMicros(long whenInMicros) {
        long whenInMillis = whenInMicros / 1000L;
        long nanos = (whenInMicros - whenInMillis * 1000L) * 10L;
        return new UUID(UUIDGen.createTime(UUIDGen.fromUnixTimestamp(whenInMillis, nanos)), secureRandom.nextLong());
    }

    public static UUID getTimeUUID(long when, long nanos) {
        return new UUID(UUIDGen.createTime(UUIDGen.fromUnixTimestamp(when, nanos)), clockSeqAndNode);
    }

    @VisibleForTesting
    public static UUID getTimeUUID(long when, long nanos, long clockSeqAndNode) {
        return new UUID(UUIDGen.createTime(UUIDGen.fromUnixTimestamp(when, nanos)), clockSeqAndNode);
    }

    public static UUID getUUID(ByteBuffer raw) {
        return new UUID(raw.getLong(raw.position()), raw.getLong(raw.position() + 8));
    }

    public static ByteBuffer toByteBuffer(UUID uuid) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        buffer.flip();
        return buffer;
    }

    public static byte[] decompose(UUID uuid) {
        long most = uuid.getMostSignificantBits();
        long least = uuid.getLeastSignificantBits();
        byte[] b = new byte[16];
        for (int i = 0; i < 8; ++i) {
            b[i] = (byte)(most >>> (7 - i) * 8);
            b[8 + i] = (byte)(least >>> (7 - i) * 8);
        }
        return b;
    }

    public static byte[] getTimeUUIDBytes() {
        return UUIDGen.createTimeUUIDBytes(instance.createTimeSafe());
    }

    public static UUID minTimeUUID(long timestamp) {
        return new UUID(UUIDGen.createTime(UUIDGen.fromUnixTimestamp(timestamp)), -9187201950435737472L);
    }

    public static UUID maxTimeUUID(long timestamp) {
        long uuidTstamp = UUIDGen.fromUnixTimestamp(timestamp + 1L) - 1L;
        return new UUID(UUIDGen.createTime(uuidTstamp), 0x7F7F7F7F7F7F7F7FL);
    }

    public static long unixTimestamp(UUID uuid) {
        return uuid.timestamp() / 10000L + -12219292800000L;
    }

    public static int unixTimestampInSec(UUID uuid) {
        return Ints.checkedCast(TimeUnit.MILLISECONDS.toSeconds(UUIDGen.unixTimestamp(uuid)));
    }

    public static long microsTimestamp(UUID uuid) {
        return uuid.timestamp() / 10L + -12219292800000000L;
    }

    private static long fromUnixTimestamp(long timestamp) {
        return UUIDGen.fromUnixTimestamp(timestamp, 0L);
    }

    private static long fromUnixTimestamp(long timestamp, long nanos) {
        return (timestamp - -12219292800000L) * 10000L + nanos;
    }

    public static byte[] getTimeUUIDBytes(long timeMillis, int nanos) {
        if (nanos >= 10000) {
            throw new IllegalArgumentException();
        }
        return UUIDGen.createTimeUUIDBytes(instance.createTimeUnsafe(timeMillis, nanos));
    }

    private static byte[] createTimeUUIDBytes(long msb) {
        int i;
        long lsb = clockSeqAndNode;
        byte[] uuidBytes = new byte[16];
        for (i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
        }
        for (i = 8; i < 16; ++i) {
            uuidBytes[i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return uuidBytes;
    }

    public static long getAdjustedTimestamp(UUID uuid) {
        if (uuid.version() != 1) {
            throw new IllegalArgumentException("incompatible with uuid version: " + uuid.version());
        }
        return uuid.timestamp() / 10000L + -12219292800000L;
    }

    private static long makeClockSeqAndNode() {
        long clock = new SecureRandom().nextLong();
        long lsb = 0L;
        lsb |= Long.MIN_VALUE;
        lsb |= (clock & 0x3FFFL) << 48;
        return lsb |= UUIDGen.makeNode();
    }

    private long createTimeSafe() {
        long newLastNanos;
        block1: {
            long originalLastNanos;
            while ((newLastNanos = (System.currentTimeMillis() - -12219292800000L) * 10000L) > (originalLastNanos = this.lastNanos.get())) {
                if (!this.lastNanos.compareAndSet(originalLastNanos, newLastNanos)) continue;
                break block1;
            }
            newLastNanos = this.lastNanos.incrementAndGet();
        }
        return UUIDGen.createTime(newLastNanos);
    }

    private long createTimeUnsafe(long when, int nanos) {
        long nanosSince = (when - -12219292800000L) * 10000L + (long)nanos;
        return UUIDGen.createTime(nanosSince);
    }

    private static long createTime(long nanosSince) {
        long msb = 0L;
        msb |= (0xFFFFFFFFL & nanosSince) << 32;
        msb |= (0xFFFF00000000L & nanosSince) >>> 16;
        msb |= (0xFFFF000000000000L & nanosSince) >>> 48;
        return msb |= 0x1000L;
    }

    private static long makeNode() {
        Collection<InetAddressAndPort> localAddresses = UUIDGen.getAllLocalAddresses();
        if (localAddresses.isEmpty()) {
            throw new RuntimeException("Cannot generate the node component of the UUID because cannot retrieve any IP addresses.");
        }
        byte[] hash = UUIDGen.hash(localAddresses);
        long node = 0L;
        for (int i = 0; i < Math.min(6, hash.length); ++i) {
            node |= (0xFFL & (long)hash[i]) << (5 - i) * 8;
        }
        assert ((0xFF00000000000000L & node) == 0L);
        return node | 0x10000000000L;
    }

    private static byte[] hash(Collection<InetAddressAndPort> data) {
        Hasher hasher = Hashing.md5().newHasher();
        for (InetAddressAndPort addr : data) {
            hasher.putBytes(addr.addressBytes);
            hasher.putInt(addr.port);
        }
        long pid = NativeLibrary.getProcessID();
        if (pid < 0L) {
            pid = new Random(System.currentTimeMillis()).nextLong();
        }
        UUIDGen.updateWithLong(hasher, pid);
        ClassLoader loader = UUIDGen.class.getClassLoader();
        int loaderId = loader != null ? System.identityHashCode(loader) : 0;
        UUIDGen.updateWithInt(hasher, loaderId);
        return hasher.hash().asBytes();
    }

    private static void updateWithInt(Hasher hasher, int val) {
        hasher.putByte((byte)(val >>> 24 & 0xFF));
        hasher.putByte((byte)(val >>> 16 & 0xFF));
        hasher.putByte((byte)(val >>> 8 & 0xFF));
        hasher.putByte((byte)(val >>> 0 & 0xFF));
    }

    public static void updateWithLong(Hasher hasher, long val) {
        hasher.putByte((byte)(val >>> 56 & 0xFFL));
        hasher.putByte((byte)(val >>> 48 & 0xFFL));
        hasher.putByte((byte)(val >>> 40 & 0xFFL));
        hasher.putByte((byte)(val >>> 32 & 0xFFL));
        hasher.putByte((byte)(val >>> 24 & 0xFFL));
        hasher.putByte((byte)(val >>> 16 & 0xFFL));
        hasher.putByte((byte)(val >>> 8 & 0xFFL));
        hasher.putByte((byte)(val >>> 0 & 0xFFL));
    }

    public static Collection<InetAddressAndPort> getAllLocalAddresses() {
        HashSet<InetAddressAndPort> localAddresses = new HashSet<InetAddressAndPort>();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            if (nets != null) {
                while (nets.hasMoreElements()) {
                    Function<InetAddress, InetAddressAndPort> converter = address -> InetAddressAndPort.getByAddressOverrideDefaults(address, 0);
                    List addresses = Collections.list(nets.nextElement().getInetAddresses()).stream().map(converter).collect(Collectors.toList());
                    localAddresses.addAll(addresses);
                }
            }
        }
        catch (SocketException e) {
            throw new AssertionError((Object)e);
        }
        if (DatabaseDescriptor.isDaemonInitialized()) {
            localAddresses.add(FBUtilities.getBroadcastAddressAndPort());
            localAddresses.add(FBUtilities.getBroadcastNativeAddressAndPort());
            localAddresses.add(FBUtilities.getLocalAddressAndPort());
        }
        return localAddresses;
    }
}

