/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.adapters.base;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.sidecar.adapters.base.jmx.TableJmxOperations;
import org.apache.cassandra.sidecar.common.server.JmxClient;
import org.apache.cassandra.sidecar.common.server.TableOperations;
import org.jetbrains.annotations.NotNull;

public class CassandraTableOperations
implements TableOperations {
    private final JmxClient jmxClient;

    public CassandraTableOperations(JmxClient jmxClient) {
        this.jmxClient = jmxClient;
    }

    public List<String> importNewSSTables(@NotNull String keyspace, @NotNull String tableName, @NotNull String directory, boolean resetLevel, boolean clearRepaired, boolean verifySSTables, boolean verifyTokens, boolean invalidateCaches, boolean extendedVerify, boolean copyData) {
        return ((TableJmxOperations)this.jmxClient.proxy(TableJmxOperations.class, this.tableMBeanName(keyspace, tableName))).importNewSSTables(Collections.singleton(directory), resetLevel, clearRepaired, verifySSTables, verifyTokens, invalidateCaches, extendedVerify, copyData);
    }

    public List<String> getDataPaths(@NotNull String keyspace, @NotNull String table) throws IOException {
        return ((TableJmxOperations)this.jmxClient.proxy(TableJmxOperations.class, this.tableMBeanName(keyspace, table))).getDataPaths();
    }

    String tableMBeanName(String keyspace, String tableName) {
        return String.format("org.apache.cassandra.db:type=%s,keyspace=%s,table=%s", tableName.contains(".") ? "IndexTables" : "Tables", keyspace, tableName);
    }
}

