/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authorization;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.RoleAuthorizationsCache;
import org.apache.cassandra.sidecar.utils.AuthUtils;

public class RoleBasedAuthorizationProvider
implements AuthorizationProvider {
    private final RoleAuthorizationsCache roleAuthorizationsCache;

    public RoleBasedAuthorizationProvider(RoleAuthorizationsCache roleAuthorizationsCache) {
        this.roleAuthorizationsCache = roleAuthorizationsCache;
    }

    public String getId() {
        return "RoleBasedAccessControl";
    }

    public void getAuthorizations(User user, Handler<AsyncResult<Void>> handler) {
        this.getAuthorizations(user).onComplete(handler);
    }

    public Future<Void> getAuthorizations(User user) {
        List<String> roles = AuthUtils.extractCassandraRoles(user);
        if (roles.isEmpty()) {
            return Future.failedFuture((String)"No cassandra roles found associated with the user");
        }
        for (String role : roles) {
            if (role == null) continue;
            String authorizationId = this.getId();
            Set<Authorization> authorizations = this.roleAuthorizationsCache.getAuthorizations(role);
            if (authorizations == null) continue;
            user.authorizations().add(authorizationId, authorizations);
        }
        return Future.succeededFuture();
    }
}

