/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.cassandra.sidecar.config.MetricsFilteringConfiguration;

public class MetricsFilteringConfigurationImpl
implements MetricsFilteringConfiguration {
    public static final String REGEX_TYPE = "regex";
    public static final String EQUALS_TYPE = "equals";
    public static final String DEFAULT_TYPE = "regex";
    public static final String DEFAULT_VALUE = ".*";
    private String type;
    @JsonProperty(value="value")
    private final String value;

    public MetricsFilteringConfigurationImpl() {
        this("regex", DEFAULT_VALUE);
    }

    public MetricsFilteringConfigurationImpl(String type, String value) {
        this.type = type;
        this.verifyType(type);
        this.value = value;
    }

    private void verifyType(String type) {
        if ("regex".equalsIgnoreCase(type) || EQUALS_TYPE.equalsIgnoreCase(type)) {
            return;
        }
        throw new IllegalArgumentException(type + " passed for metric filtering is not recognized. Expected types are regex or equals");
    }

    @Override
    public String type() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.verifyType(type);
        this.type = type;
    }

    @Override
    public String value() {
        return this.value;
    }
}

