/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.SidecarClientConfiguration;
import org.apache.cassandra.sidecar.config.SslConfiguration;

public class SidecarClientConfigurationImpl
implements SidecarClientConfiguration {
    public static final String SSL_CONFIGURATION = "ssl";
    public static final String REQUEST_TIMEOUT = "request_timeout";
    public static final String REQUEST_IDLE_TIMEOUT = "request_idle_timeout";
    public static final String CONNECTION_POOL_MAX_SIZE = "connection_pool_max_size";
    public static final String CONNECTION_POOL_CLEANER_PERIOD = "connection_pool_clearing_period";
    public static final String CONNECTION_POOL_EVENT_LOOP_SIZE = "connection_pool_event_loop_size";
    public static final String CONNECTION_POOL_MAX_WAIT_QUEUE_SIZE = "connection_pool_max_wait_queue_size";
    public static final String MAX_RETRIES = "max_retries";
    public static final String RETRY_DELAY = "retry_delay";
    public static final String MAX_RETRY_DELAY = "max_retry_delay";
    public static final SslConfiguration DEFAULT_SSL_CONFIGURATION = null;
    public static final MillisecondBoundConfiguration DEFAULT_REQUEST_TIMEOUT = MillisecondBoundConfiguration.parse((String)"30s");
    public static final MillisecondBoundConfiguration DEFAULT_REQUEST_IDLE_TIMEOUT = MillisecondBoundConfiguration.parse((String)"30s");
    public static final int DEFAULT_CONNECTION_POOL_MAX_SIZE = 10;
    public static final MillisecondBoundConfiguration DEFAULT_CONNECTION_POOL_CLEANER_PERIOD = MillisecondBoundConfiguration.parse((String)"5s");
    public static final int DEFAULT_CONNECTION_POOL_EVENT_LOOP_SIZE = 0;
    public static final int DEFAULT_CONNECTION_POOL_MAX_WAIT_QUEUE_SIZE = -1;
    public static final int DEFAULT_MAX_RETRIES = 5;
    public static final MillisecondBoundConfiguration DEFAULT_RETRY_DELAY = MillisecondBoundConfiguration.parse((String)"500ms");
    public static final MillisecondBoundConfiguration DEFAULT_MAX_RETRY_DELAY = MillisecondBoundConfiguration.parse((String)"10s");
    @JsonProperty(value="ssl")
    protected final SslConfiguration sslConfiguration;
    @JsonProperty(value="request_timeout")
    protected final MillisecondBoundConfiguration requestTimeout;
    @JsonProperty(value="request_idle_timeout")
    protected final MillisecondBoundConfiguration requestIdleTimeout;
    @JsonProperty(value="connection_pool_max_size")
    protected final int connectionPoolMaxSize;
    @JsonProperty(value="connection_pool_clearing_period")
    protected final MillisecondBoundConfiguration connectionPoolCleanerPeriod;
    @JsonProperty(value="connection_pool_event_loop_size")
    protected final int connectionPoolEventLoopSize;
    @JsonProperty(value="connection_pool_max_wait_queue_size")
    protected final int connectionPoolEventMaxWaitQueueSize;
    @JsonProperty(value="max_retries")
    protected final int maxRetries;
    @JsonProperty(value="retry_delay")
    protected final MillisecondBoundConfiguration retryDelay;
    @JsonProperty(value="max_retry_delay")
    protected final MillisecondBoundConfiguration maxRetryDelay;

    public SidecarClientConfigurationImpl() {
        this(DEFAULT_SSL_CONFIGURATION, DEFAULT_REQUEST_TIMEOUT, DEFAULT_REQUEST_IDLE_TIMEOUT, 10, DEFAULT_CONNECTION_POOL_CLEANER_PERIOD, 0, -1, 5, DEFAULT_RETRY_DELAY, DEFAULT_MAX_RETRY_DELAY);
    }

    public SidecarClientConfigurationImpl(SslConfiguration sslConfiguration) {
        this(sslConfiguration, DEFAULT_REQUEST_TIMEOUT, DEFAULT_REQUEST_IDLE_TIMEOUT, 10, DEFAULT_CONNECTION_POOL_CLEANER_PERIOD, 0, -1, 5, DEFAULT_RETRY_DELAY, DEFAULT_MAX_RETRY_DELAY);
    }

    public SidecarClientConfigurationImpl(SslConfiguration sslConfiguration, MillisecondBoundConfiguration requestTimeout, MillisecondBoundConfiguration requestIdleTimeout, int connectionPoolMaxSize, MillisecondBoundConfiguration connectionPoolCleanerPeriod, int connectionPoolEventLoopSize, int connectionPoolEventMaxWaitQueueSize, int maxRetries, MillisecondBoundConfiguration retryDelay, MillisecondBoundConfiguration maxRetryDelay) {
        this.sslConfiguration = sslConfiguration;
        this.requestTimeout = requestTimeout;
        this.requestIdleTimeout = requestIdleTimeout;
        this.connectionPoolMaxSize = connectionPoolMaxSize;
        this.connectionPoolCleanerPeriod = connectionPoolCleanerPeriod;
        this.connectionPoolEventLoopSize = connectionPoolEventLoopSize;
        this.connectionPoolEventMaxWaitQueueSize = connectionPoolEventMaxWaitQueueSize;
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
        this.maxRetryDelay = maxRetryDelay;
    }

    @Override
    public SslConfiguration sslConfiguration() {
        return this.sslConfiguration;
    }

    @Override
    public MillisecondBoundConfiguration requestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public MillisecondBoundConfiguration requestIdleTimeout() {
        return this.requestIdleTimeout;
    }

    @Override
    public int connectionPoolMaxSize() {
        return this.connectionPoolMaxSize;
    }

    @Override
    public MillisecondBoundConfiguration connectionPoolCleanerPeriod() {
        return this.connectionPoolCleanerPeriod;
    }

    @Override
    public int connectionPoolEventLoopSize() {
        return this.connectionPoolEventLoopSize;
    }

    @Override
    public int connectionPoolMaxWaitQueueSize() {
        return this.connectionPoolEventMaxWaitQueueSize;
    }

    @Override
    public int maxRetries() {
        return this.maxRetries;
    }

    @Override
    public MillisecondBoundConfiguration retryDelay() {
        return this.retryDelay;
    }

    @Override
    public MillisecondBoundConfiguration maxRetryDelay() {
        return this.maxRetryDelay;
    }
}

